% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-nds-methods.R
\name{getNdsAge}
\alias{getNdsAge}
\title{Get ages for multiple nodes}
\usage{
getNdsAge(tree, ids, tree_age, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{vector of node ids}

\item{tree_age}{numeric value of known age of tree}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return the age for \code{ids}.
}
\details{
Returns a vector, parallelizable.
}
\examples{
library(treeman)
tree <- randTree(10)
getNdsAge(tree, ids=tree['nds'], tree_age=getAge(tree))
}
\seealso{
\code{\link{getNdAge}}, 
\code{\link{getSpnAge}}, 
\code{\link{getSpnsAge}}, 
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
