% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-spcl-methods.R
\name{getPath}
\alias{getPath}
\title{Get path between nodes}
\usage{
getPath(tree, from, to)
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{from}{starting node id}

\item{to}{ending node id}
}
\description{
Return node ids for connecting \code{from} to \code{to}.
}
\details{
Returns a vector, first id is \code{from} to \code{to}.
}
\examples{
library(treeman)
data(mammals)
# what's the phylogenetic distance from humans to gorillas?
ape_id <- getPrnt(mammals, ids=c('Homo_sapiens', 'Hylobates_concolor'))
pth <- getPath(mammals, from='Homo_sapiens', to='Gorilla_gorilla')
sum(getNdsSlt(mammals, ids=pth, slt_nm='spn'))
}
\seealso{
\url{https://github.com/DomBennett/treeman/wiki/get-methods}
}
