% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set-methods.R
\name{setNdsOther}
\alias{setNdsOther}
\title{Set a user defined slot for multiple nodes}
\usage{
setNdsOther(tree, ids, vals, slt_nm, parallel = FALSE, progress = "none")
}
\arguments{
\item{tree}{\code{TreeMan} object}

\item{ids}{id sof the nodes}

\item{vals}{data for slot}

\item{slt_nm}{slot name}

\item{parallel}{logical, make parallel?}

\item{progress}{name of the progress bar to use, see \code{\link{create_progress_bar}}}
}
\description{
Return a tree with a user defined slot for node IDs.
}
\details{
Runs \code{setNdOther()} over multiple nodes. Parellizable.
}
\examples{
library(treeman)
tree <- randTree(10)
# e.g. confidences for nodes
vals <- runif(min=0, max=1, n=tree['nall'])
tree <- setNdsOther(tree, tree['all'], vals, 'confidence')
tree <- updateSlts(tree)
summary(tree)
(getNdsSlt(tree, ids=tree['all'], slt_nm='confidence'))
}
\seealso{
\code{\link{setNdOther}}
\url{https://github.com/DomBennett/treeman/wiki/set-methods}
}
