% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepanel.R
\name{setLims}
\alias{setLims}
\title{Specify Rules for x and y Limits for a Display}
\usage{
setLims(lims, x = "same", y = "same", xQuant = c(0, 1), yQuant = c(0,
  1), xRangeQuant = 1, yRangeQuant = 1, prop = 0.07)
}
\arguments{
\item{lims}{object of class "trsPre"}

\item{x}{x-axis limits rule (either "same", "sliced", or "free" - see details)}

\item{y}{y-axis limits rule (either "same", "sliced", or "free" - see details)}

\item{xQuant}{lower and upper quantiles at which to cut off x-axis limits, in the case of outliers.  Used when x="same".}

\item{yQuant}{same as xQuant but for y-axis}

\item{xRangeQuant}{a single upper quantile at which to cut off the x-axis range, used when x="sliced", used in the case of a few splits having abnormally high range, which are wished to be excluded}

\item{yRangeQuant}{same as xRangeQuant but for y-axis}

\item{prop}{the proportion of the axis range to pad beyond the actual axis range}
}
\value{
object of class "trsLims", which can be used in a call to \code{\link{makeDisplay}}
}
\description{
Based on results from \code{\link{prepanel}}, specify rules that will determine x and y axis limits to be passed as the \code{lims} argument when calling \code{\link{makeDisplay}}.
}
\details{
This function reduces the list of axis limits computed for each split of a data set to an overall axis limit rule for the plot.

About "x" and "y" parameters: This is the same as in lattice.  From lattice documentation:
A character string that determines how axis limits are calculated for each panel. Possible values are "same" (default), "free" and "sliced". For relation="same", the same limits, usually large enough to encompass all the data, are used for all the panels. For relation="free", limits for each panel is determined by just the points in that panel. Behavior for relation="sliced" is similar, except that the length (max - min) of the scales are constrained to remain the same across panels.
}
\examples{
\dontrun{
irisSplit <- datadr::divide(iris, "Species")
irisPreFn <- function(x) {
  list(
    xlim = range(x$Sepal.Length),
    ylim = range(x$Sepal.Width)
  )
}
irisPre <- prepanel(irisSplit, prepanelFn = irisPreFn)
irisLims <- setLims(irisPre, x = "same", y = "sliced")
}

d <- datadr::divide(iris, "Species")

irisPreFn <- function(x) {
  list(
    xlim = range(x$Sepal.Length),
    ylim = range(x$Sepal.Width)
  )
}

irisPre <- prepanel(d, prepanelFn = irisPreFn)

plot(irisPre)

irisLims <- setLims(irisPre, x = "same", y = "sliced")
}
\seealso{
\code{\link{prepanel}}, \code{\link{makeDisplay}}
}
