
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_BebopInPeps2_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_BebopInPeps2");
    reader.add_event(84, 84, "end", "model_BebopInPeps2");
    return reader;
}

template <typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__>
typename boost::math::tools::promote_args<T6__, T7__, T8__, T9__, typename boost::math::tools::promote_args<T10__, T11__>::type>::type
log_joint_pdf(const int& J,
                  const std::vector<int>& eff,
                  const std::vector<int>& tox,
                  const std::vector<int>& x1,
                  const std::vector<int>& x2,
                  const std::vector<int>& x3,
                  const T6__& alpha,
                  const T7__& beta,
                  const T8__& gamma,
                  const T9__& zeta,
                  const T10__& lambda,
                  const T11__& psi, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T6__, T7__, T8__, T9__, typename boost::math::tools::promote_args<T10__, T11__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        fun_scalar_t__ p;
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);


        stan::math::assign(p, 0);
        for (int j = 1; j <= J; ++j) {
            {
            fun_scalar_t__ prob1;
            (void) prob1;  // dummy to suppress unused var warning

            stan::math::initialize(prob1, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob1,DUMMY_VAR__);
            fun_scalar_t__ prob2;
            (void) prob2;  // dummy to suppress unused var warning

            stan::math::initialize(prob2, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob2,DUMMY_VAR__);
            fun_scalar_t__ p_delta;
            (void) p_delta;  // dummy to suppress unused var warning

            stan::math::initialize(p_delta, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p_delta,DUMMY_VAR__);


            stan::math::assign(prob1, inv_logit((((alpha + (beta * get_base1(x1,j,"x1",1))) + (gamma * get_base1(x2,j,"x2",1))) + (zeta * get_base1(x3,j,"x3",1)))));
            stan::math::assign(prob2, inv_logit(lambda));
            stan::math::assign(p_delta, ((((pow(prob1,get_base1(eff,j,"eff",1)) * pow((1 - prob1),(1 - get_base1(eff,j,"eff",1)))) * pow(prob2,get_base1(tox,j,"tox",1))) * pow((1 - prob2),(1 - get_base1(tox,j,"tox",1)))) + ((((((pow(-(1),(get_base1(eff,j,"eff",1) + get_base1(tox,j,"tox",1))) * prob1) * prob2) * (1 - prob1)) * (1 - prob2)) * (exp(psi) - 1)) / (exp(psi) + 1))));
            stan::math::assign(p, (p + log(p_delta)));
            }
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(p);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct log_joint_pdf_functor__ {
    template <typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__>
        typename boost::math::tools::promote_args<T6__, T7__, T8__, T9__, typename boost::math::tools::promote_args<T10__, T11__>::type>::type
    operator()(const int& J,
                  const std::vector<int>& eff,
                  const std::vector<int>& tox,
                  const std::vector<int>& x1,
                  const std::vector<int>& x2,
                  const std::vector<int>& x3,
                  const T6__& alpha,
                  const T7__& beta,
                  const T8__& gamma,
                  const T9__& zeta,
                  const T10__& lambda,
                  const T11__& psi, std::ostream* pstream__) const {
        return log_joint_pdf(J, eff, tox, x1, x2, x3, alpha, beta, gamma, zeta, lambda, psi, pstream__);
    }
};

class model_BebopInPeps2 : public prob_grad {
private:
    int J;
    vector<int> eff;
    vector<int> tox;
    vector<int> x1;
    vector<int> x2;
    vector<int> x3;
    double alpha_mean;
    double alpha_sd;
    double beta_mean;
    double beta_sd;
    double gamma_mean;
    double gamma_sd;
    double zeta_mean;
    double zeta_sd;
    double lambda_mean;
    double lambda_sd;
    double psi_mean;
    double psi_sd;
public:
    model_BebopInPeps2(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_BebopInPeps2(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_BebopInPeps2_namespace::model_BebopInPeps2";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "J", "int", context__.to_vec());
            J = int(0);
            vals_i__ = context__.vals_i("J");
            pos__ = 0;
            J = vals_i__[pos__++];
            validate_non_negative_index("eff", "J", J);
            context__.validate_dims("data initialization", "eff", "int", context__.to_vec(J));
            validate_non_negative_index("eff", "J", J);
            eff = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("eff");
            pos__ = 0;
            size_t eff_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < eff_limit_0__; ++i_0__) {
                eff[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("tox", "J", J);
            context__.validate_dims("data initialization", "tox", "int", context__.to_vec(J));
            validate_non_negative_index("tox", "J", J);
            tox = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("tox");
            pos__ = 0;
            size_t tox_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < tox_limit_0__; ++i_0__) {
                tox[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("x1", "J", J);
            context__.validate_dims("data initialization", "x1", "int", context__.to_vec(J));
            validate_non_negative_index("x1", "J", J);
            x1 = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("x1");
            pos__ = 0;
            size_t x1_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < x1_limit_0__; ++i_0__) {
                x1[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("x2", "J", J);
            context__.validate_dims("data initialization", "x2", "int", context__.to_vec(J));
            validate_non_negative_index("x2", "J", J);
            x2 = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("x2");
            pos__ = 0;
            size_t x2_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < x2_limit_0__; ++i_0__) {
                x2[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("x3", "J", J);
            context__.validate_dims("data initialization", "x3", "int", context__.to_vec(J));
            validate_non_negative_index("x3", "J", J);
            x3 = std::vector<int>(J,int(0));
            vals_i__ = context__.vals_i("x3");
            pos__ = 0;
            size_t x3_limit_0__ = J;
            for (size_t i_0__ = 0; i_0__ < x3_limit_0__; ++i_0__) {
                x3[i_0__] = vals_i__[pos__++];
            }
            context__.validate_dims("data initialization", "alpha_mean", "double", context__.to_vec());
            alpha_mean = double(0);
            vals_r__ = context__.vals_r("alpha_mean");
            pos__ = 0;
            alpha_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "alpha_sd", "double", context__.to_vec());
            alpha_sd = double(0);
            vals_r__ = context__.vals_r("alpha_sd");
            pos__ = 0;
            alpha_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta_mean", "double", context__.to_vec());
            beta_mean = double(0);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            beta_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta_sd", "double", context__.to_vec());
            beta_sd = double(0);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            beta_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "gamma_mean", "double", context__.to_vec());
            gamma_mean = double(0);
            vals_r__ = context__.vals_r("gamma_mean");
            pos__ = 0;
            gamma_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "gamma_sd", "double", context__.to_vec());
            gamma_sd = double(0);
            vals_r__ = context__.vals_r("gamma_sd");
            pos__ = 0;
            gamma_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "zeta_mean", "double", context__.to_vec());
            zeta_mean = double(0);
            vals_r__ = context__.vals_r("zeta_mean");
            pos__ = 0;
            zeta_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "zeta_sd", "double", context__.to_vec());
            zeta_sd = double(0);
            vals_r__ = context__.vals_r("zeta_sd");
            pos__ = 0;
            zeta_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "lambda_mean", "double", context__.to_vec());
            lambda_mean = double(0);
            vals_r__ = context__.vals_r("lambda_mean");
            pos__ = 0;
            lambda_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "lambda_sd", "double", context__.to_vec());
            lambda_sd = double(0);
            vals_r__ = context__.vals_r("lambda_sd");
            pos__ = 0;
            lambda_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "psi_mean", "double", context__.to_vec());
            psi_mean = double(0);
            vals_r__ = context__.vals_r("psi_mean");
            pos__ = 0;
            psi_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "psi_sd", "double", context__.to_vec());
            psi_sd = double(0);
            vals_r__ = context__.vals_r("psi_sd");
            pos__ = 0;
            psi_sd = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"J",J,0);
            for (int k0__ = 0; k0__ < J; ++k0__) {
                check_greater_or_equal(function__,"eff[k0__]",eff[k0__],0);
                check_less_or_equal(function__,"eff[k0__]",eff[k0__],1);
            }
            for (int k0__ = 0; k0__ < J; ++k0__) {
                check_greater_or_equal(function__,"tox[k0__]",tox[k0__],0);
                check_less_or_equal(function__,"tox[k0__]",tox[k0__],1);
            }
            for (int k0__ = 0; k0__ < J; ++k0__) {
                check_greater_or_equal(function__,"x1[k0__]",x1[k0__],0);
                check_less_or_equal(function__,"x1[k0__]",x1[k0__],1);
            }
            for (int k0__ = 0; k0__ < J; ++k0__) {
                check_greater_or_equal(function__,"x2[k0__]",x2[k0__],0);
                check_less_or_equal(function__,"x2[k0__]",x2[k0__],1);
            }
            for (int k0__ = 0; k0__ < J; ++k0__) {
                check_greater_or_equal(function__,"x3[k0__]",x3[k0__],0);
                check_less_or_equal(function__,"x3[k0__]",x3[k0__],1);
            }
            check_greater_or_equal(function__,"alpha_sd",alpha_sd,0);
            check_greater_or_equal(function__,"beta_sd",beta_sd,0);
            check_greater_or_equal(function__,"gamma_sd",gamma_sd,0);
            check_greater_or_equal(function__,"zeta_sd",zeta_sd,0);
            check_greater_or_equal(function__,"lambda_sd",lambda_sd,0);
            check_greater_or_equal(function__,"psi_sd",psi_sd,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_BebopInPeps2() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        if (!(context__.contains_r("gamma")))
            throw std::runtime_error("variable gamma missing");
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("initialization", "gamma", "double", context__.to_vec());
        double gamma(0);
        gamma = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(gamma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gamma: ") + e.what());
        }

        if (!(context__.contains_r("zeta")))
            throw std::runtime_error("variable zeta missing");
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("initialization", "zeta", "double", context__.to_vec());
        double zeta(0);
        zeta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(zeta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable zeta: ") + e.what());
        }

        if (!(context__.contains_r("lambda")))
            throw std::runtime_error("variable lambda missing");
        vals_r__ = context__.vals_r("lambda");
        pos__ = 0U;
        context__.validate_dims("initialization", "lambda", "double", context__.to_vec());
        double lambda(0);
        lambda = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(lambda);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable lambda: ") + e.what());
        }

        if (!(context__.contains_r("psi")))
            throw std::runtime_error("variable psi missing");
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        context__.validate_dims("initialization", "psi", "double", context__.to_vec());
        double psi(0);
        psi = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(psi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_constrain(lp__);
            else
                alpha = in__.scalar_constrain();

            T__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();

            T__ gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.scalar_constrain(lp__);
            else
                gamma = in__.scalar_constrain();

            T__ zeta;
            (void) zeta;  // dummy to suppress unused var warning
            if (jacobian__)
                zeta = in__.scalar_constrain(lp__);
            else
                zeta = in__.scalar_constrain();

            T__ lambda;
            (void) lambda;  // dummy to suppress unused var warning
            if (jacobian__)
                lambda = in__.scalar_constrain(lp__);
            else
                lambda = in__.scalar_constrain();

            T__ psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.scalar_constrain(lp__);
            else
                psi = in__.scalar_constrain();


            // transformed parameters
            validate_non_negative_index("prob_eff", "6", 6);
            vector<T__> prob_eff(6);
            stan::math::initialize(prob_eff, DUMMY_VAR__);
            stan::math::fill(prob_eff,DUMMY_VAR__);
            validate_non_negative_index("prob_tox", "6", 6);
            vector<T__> prob_tox(6);
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox,DUMMY_VAR__);


            stan::math::assign(get_base1_lhs(prob_eff,1,"prob_eff",1), inv_logit((((alpha + (beta * 0)) + (gamma * 1)) + (zeta * 0))));
            stan::math::assign(get_base1_lhs(prob_eff,2,"prob_eff",1), inv_logit((((alpha + (beta * 0)) + (gamma * 0)) + (zeta * 1))));
            stan::math::assign(get_base1_lhs(prob_eff,3,"prob_eff",1), inv_logit((((alpha + (beta * 0)) + (gamma * 0)) + (zeta * 0))));
            stan::math::assign(get_base1_lhs(prob_eff,4,"prob_eff",1), inv_logit((((alpha + (beta * 1)) + (gamma * 1)) + (zeta * 0))));
            stan::math::assign(get_base1_lhs(prob_eff,5,"prob_eff",1), inv_logit((((alpha + (beta * 1)) + (gamma * 0)) + (zeta * 1))));
            stan::math::assign(get_base1_lhs(prob_eff,6,"prob_eff",1), inv_logit((((alpha + (beta * 1)) + (gamma * 0)) + (zeta * 0))));
            stan::math::assign(get_base1_lhs(prob_tox,1,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,2,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,3,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,4,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,5,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,6,"prob_tox",1), inv_logit(lambda));

            // validate transformed parameters
            for (int i0__ = 0; i0__ < 6; ++i0__) {
                if (stan::math::is_uninitialized(prob_eff[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_eff" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < 6; ++i0__) {
                if (stan::math::is_uninitialized(prob_tox[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_tox" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            for (int k0__ = 0; k0__ < 6; ++k0__) {
                check_greater_or_equal(function__,"prob_eff[k0__]",prob_eff[k0__],0);
                check_less_or_equal(function__,"prob_eff[k0__]",prob_eff[k0__],1);
            }
            for (int k0__ = 0; k0__ < 6; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // model body

            lp_accum__.add(normal_log(alpha,alpha_mean,alpha_sd));
            lp_accum__.add(normal_log(beta,beta_mean,beta_sd));
            lp_accum__.add(normal_log(gamma,gamma_mean,gamma_sd));
            lp_accum__.add(normal_log(zeta,zeta_mean,zeta_sd));
            lp_accum__.add(normal_log(lambda,lambda_mean,lambda_sd));
            lp_accum__.add(normal_log(psi,psi_mean,psi_sd));
            lp_accum__.add(log_joint_pdf(J,eff,tox,x1,x2,x3,alpha,beta,gamma,zeta,lambda,psi, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("zeta");
        names__.push_back("lambda");
        names__.push_back("psi");
        names__.push_back("prob_eff");
        names__.push_back("prob_tox");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(6);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_BebopInPeps2_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double alpha = in__.scalar_constrain();
        double beta = in__.scalar_constrain();
        double gamma = in__.scalar_constrain();
        double zeta = in__.scalar_constrain();
        double lambda = in__.scalar_constrain();
        double psi = in__.scalar_constrain();
        vars__.push_back(alpha);
        vars__.push_back(beta);
        vars__.push_back(gamma);
        vars__.push_back(zeta);
        vars__.push_back(lambda);
        vars__.push_back(psi);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("prob_eff", "6", 6);
            vector<double> prob_eff(6, 0.0);
            stan::math::initialize(prob_eff, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_eff,DUMMY_VAR__);
            validate_non_negative_index("prob_tox", "6", 6);
            vector<double> prob_tox(6, 0.0);
            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);


            stan::math::assign(get_base1_lhs(prob_eff,1,"prob_eff",1), inv_logit((((alpha + (beta * 0)) + (gamma * 1)) + (zeta * 0))));
            stan::math::assign(get_base1_lhs(prob_eff,2,"prob_eff",1), inv_logit((((alpha + (beta * 0)) + (gamma * 0)) + (zeta * 1))));
            stan::math::assign(get_base1_lhs(prob_eff,3,"prob_eff",1), inv_logit((((alpha + (beta * 0)) + (gamma * 0)) + (zeta * 0))));
            stan::math::assign(get_base1_lhs(prob_eff,4,"prob_eff",1), inv_logit((((alpha + (beta * 1)) + (gamma * 1)) + (zeta * 0))));
            stan::math::assign(get_base1_lhs(prob_eff,5,"prob_eff",1), inv_logit((((alpha + (beta * 1)) + (gamma * 0)) + (zeta * 1))));
            stan::math::assign(get_base1_lhs(prob_eff,6,"prob_eff",1), inv_logit((((alpha + (beta * 1)) + (gamma * 0)) + (zeta * 0))));
            stan::math::assign(get_base1_lhs(prob_tox,1,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,2,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,3,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,4,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,5,"prob_tox",1), inv_logit(lambda));
            stan::math::assign(get_base1_lhs(prob_tox,6,"prob_tox",1), inv_logit(lambda));

            // validate transformed parameters
            for (int k0__ = 0; k0__ < 6; ++k0__) {
                check_greater_or_equal(function__,"prob_eff[k0__]",prob_eff[k0__],0);
                check_less_or_equal(function__,"prob_eff[k0__]",prob_eff[k0__],1);
            }
            for (int k0__ = 0; k0__ < 6; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(prob_eff[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < 6; ++k_0__) {
            vars__.push_back(prob_tox[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_BebopInPeps2";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_eff" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "lambda";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_eff" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= 6; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_CrmEmpiricNormalPrior_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_CrmEmpiricNormalPrior");
    reader.add_event(80, 80, "end", "model_CrmEmpiricNormalPrior");
    return reader;
}

template <typename T3__, typename T4__>
typename boost::math::tools::promote_args<T3__, T4__>::type
log_joint_pdf(const int& num_patients,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const std::vector<T3__>& skeleton,
                  const T4__& beta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T3__, T4__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        fun_scalar_t__ p;
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);


        stan::math::assign(p, 0);
        for (int j = 1; j <= num_patients; ++j) {
            {
            fun_scalar_t__ prob_tox;
            (void) prob_tox;  // dummy to suppress unused var warning

            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);
            fun_scalar_t__ p_j;
            (void) p_j;  // dummy to suppress unused var warning

            stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p_j,DUMMY_VAR__);


            stan::math::assign(prob_tox, pow(get_base1(skeleton,get_base1(doses,j,"doses",1),"skeleton",1),exp(beta)));
            stan::math::assign(p_j, (pow(prob_tox,get_base1(tox,j,"tox",1)) * pow((1 - prob_tox),(1 - get_base1(tox,j,"tox",1)))));
            stan::math::assign(p, (p + log(p_j)));
            }
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(p);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct log_joint_pdf_functor__ {
    template <typename T3__, typename T4__>
        typename boost::math::tools::promote_args<T3__, T4__>::type
    operator()(const int& num_patients,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const std::vector<T3__>& skeleton,
                  const T4__& beta, std::ostream* pstream__) const {
        return log_joint_pdf(num_patients, tox, doses, skeleton, beta, pstream__);
    }
};

class model_CrmEmpiricNormalPrior : public prob_grad {
private:
    double beta_sd;
    int num_doses;
    vector<double> skeleton;
    int num_patients;
    vector<int> tox;
    vector<int> doses;
public:
    model_CrmEmpiricNormalPrior(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_CrmEmpiricNormalPrior(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_CrmEmpiricNormalPrior_namespace::model_CrmEmpiricNormalPrior";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "beta_sd", "double", context__.to_vec());
            beta_sd = double(0);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            beta_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_doses", "int", context__.to_vec());
            num_doses = int(0);
            vals_i__ = context__.vals_i("num_doses");
            pos__ = 0;
            num_doses = vals_i__[pos__++];
            validate_non_negative_index("skeleton", "num_doses", num_doses);
            context__.validate_dims("data initialization", "skeleton", "double", context__.to_vec(num_doses));
            validate_non_negative_index("skeleton", "num_doses", num_doses);
            skeleton = std::vector<double>(num_doses,double(0));
            vals_r__ = context__.vals_r("skeleton");
            pos__ = 0;
            size_t skeleton_limit_0__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < skeleton_limit_0__; ++i_0__) {
                skeleton[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "num_patients", "int", context__.to_vec());
            num_patients = int(0);
            vals_i__ = context__.vals_i("num_patients");
            pos__ = 0;
            num_patients = vals_i__[pos__++];
            validate_non_negative_index("tox", "num_patients", num_patients);
            context__.validate_dims("data initialization", "tox", "int", context__.to_vec(num_patients));
            validate_non_negative_index("tox", "num_patients", num_patients);
            tox = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("tox");
            pos__ = 0;
            size_t tox_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < tox_limit_0__; ++i_0__) {
                tox[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("doses", "num_patients", num_patients);
            context__.validate_dims("data initialization", "doses", "int", context__.to_vec(num_patients));
            validate_non_negative_index("doses", "num_patients", num_patients);
            doses = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("doses");
            pos__ = 0;
            size_t doses_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < doses_limit_0__; ++i_0__) {
                doses[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"beta_sd",beta_sd,0);
            check_greater_or_equal(function__,"num_doses",num_doses,1);
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"skeleton[k0__]",skeleton[k0__],0);
                check_less_or_equal(function__,"skeleton[k0__]",skeleton[k0__],1);
            }
            check_greater_or_equal(function__,"num_patients",num_patients,0);
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"tox[k0__]",tox[k0__],0);
                check_less_or_equal(function__,"tox[k0__]",tox[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"doses[k0__]",doses[k0__],1);
                check_less_or_equal(function__,"doses[k0__]",doses[k0__],num_doses);
            }
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_CrmEmpiricNormalPrior() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();


            // transformed parameters
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<T__> prob_tox(num_doses);
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), pow(get_base1(skeleton,i,"skeleton",1),exp(beta)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(prob_tox[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_tox" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // model body

            lp_accum__.add(normal_log(beta,0,beta_sd));
            lp_accum__.add(log_joint_pdf(num_patients,tox,doses,skeleton,beta, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("prob_tox");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_patients);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_CrmEmpiricNormalPrior_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta = in__.scalar_constrain();
        vars__.push_back(beta);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<double> prob_tox(num_doses, 0.0);
            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), pow(get_base1(skeleton,i,"skeleton",1),exp(beta)));
            }

            // validate transformed parameters
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(prob_tox[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            validate_non_negative_index("log_lik", "num_patients", num_patients);
            vector_d log_lik(static_cast<Eigen::VectorXd::Index>(num_patients));
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(log_lik,DUMMY_VAR__);


            for (int j = 1; j <= num_patients; ++j) {
                {
                double p_j(0.0);
                (void) p_j;  // dummy to suppress unused var warning

                stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(p_j,DUMMY_VAR__);


                stan::math::assign(p_j, pow(get_base1(skeleton,get_base1(doses,j,"doses",1),"skeleton",1),exp(beta)));
                stan::math::assign(get_base1_lhs(log_lik,j,"log_lik",1), log((pow(p_j,get_base1(tox,j,"tox",1)) * pow((1 - p_j),(1 - get_base1(tox,j,"tox",1))))));
                }
            }

            // validate generated quantities

            // write generated quantities
            for (int k_0__ = 0; k_0__ < num_patients; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_CrmEmpiricNormalPrior";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= num_patients; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= num_patients; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_CrmOneParamLogisticGammaPrior_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_CrmOneParamLogisticGammaPrior");
    reader.add_event(95, 95, "end", "model_CrmOneParamLogisticGammaPrior");
    return reader;
}

template <typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T3__, T4__, T5__>::type
log_joint_pdf(const int& num_patients,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const std::vector<T3__>& codified_doses,
                  const T4__& a0,
                  const T5__& beta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        fun_scalar_t__ p;
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);


        stan::math::assign(p, 0);
        for (int j = 1; j <= num_patients; ++j) {
            {
            fun_scalar_t__ prob_tox;
            (void) prob_tox;  // dummy to suppress unused var warning

            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);
            fun_scalar_t__ p_j;
            (void) p_j;  // dummy to suppress unused var warning

            stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p_j,DUMMY_VAR__);


            stan::math::assign(prob_tox, inv_logit((a0 + (beta * get_base1(codified_doses,get_base1(doses,j,"doses",1),"codified_doses",1)))));
            stan::math::assign(p_j, (pow(prob_tox,get_base1(tox,j,"tox",1)) * pow((1 - prob_tox),(1 - get_base1(tox,j,"tox",1)))));
            stan::math::assign(p, (p + log(p_j)));
            }
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(p);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct log_joint_pdf_functor__ {
    template <typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T3__, T4__, T5__>::type
    operator()(const int& num_patients,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const std::vector<T3__>& codified_doses,
                  const T4__& a0,
                  const T5__& beta, std::ostream* pstream__) const {
        return log_joint_pdf(num_patients, tox, doses, codified_doses, a0, beta, pstream__);
    }
};

class model_CrmOneParamLogisticGammaPrior : public prob_grad {
private:
    double beta_shape;
    double beta_inverse_scale;
    int num_doses;
    vector<double> skeleton;
    double a0;
    int num_patients;
    vector<int> tox;
    vector<int> doses;
    vector<double> codified_doses;
public:
    model_CrmOneParamLogisticGammaPrior(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_CrmOneParamLogisticGammaPrior(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_CrmOneParamLogisticGammaPrior_namespace::model_CrmOneParamLogisticGammaPrior";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "beta_shape", "double", context__.to_vec());
            beta_shape = double(0);
            vals_r__ = context__.vals_r("beta_shape");
            pos__ = 0;
            beta_shape = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta_inverse_scale", "double", context__.to_vec());
            beta_inverse_scale = double(0);
            vals_r__ = context__.vals_r("beta_inverse_scale");
            pos__ = 0;
            beta_inverse_scale = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_doses", "int", context__.to_vec());
            num_doses = int(0);
            vals_i__ = context__.vals_i("num_doses");
            pos__ = 0;
            num_doses = vals_i__[pos__++];
            validate_non_negative_index("skeleton", "num_doses", num_doses);
            context__.validate_dims("data initialization", "skeleton", "double", context__.to_vec(num_doses));
            validate_non_negative_index("skeleton", "num_doses", num_doses);
            skeleton = std::vector<double>(num_doses,double(0));
            vals_r__ = context__.vals_r("skeleton");
            pos__ = 0;
            size_t skeleton_limit_0__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < skeleton_limit_0__; ++i_0__) {
                skeleton[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "a0", "double", context__.to_vec());
            a0 = double(0);
            vals_r__ = context__.vals_r("a0");
            pos__ = 0;
            a0 = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_patients", "int", context__.to_vec());
            num_patients = int(0);
            vals_i__ = context__.vals_i("num_patients");
            pos__ = 0;
            num_patients = vals_i__[pos__++];
            validate_non_negative_index("tox", "num_patients", num_patients);
            context__.validate_dims("data initialization", "tox", "int", context__.to_vec(num_patients));
            validate_non_negative_index("tox", "num_patients", num_patients);
            tox = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("tox");
            pos__ = 0;
            size_t tox_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < tox_limit_0__; ++i_0__) {
                tox[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("doses", "num_patients", num_patients);
            context__.validate_dims("data initialization", "doses", "int", context__.to_vec(num_patients));
            validate_non_negative_index("doses", "num_patients", num_patients);
            doses = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("doses");
            pos__ = 0;
            size_t doses_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < doses_limit_0__; ++i_0__) {
                doses[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"beta_shape",beta_shape,0);
            check_greater_or_equal(function__,"beta_inverse_scale",beta_inverse_scale,0);
            check_greater_or_equal(function__,"num_doses",num_doses,1);
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"skeleton[k0__]",skeleton[k0__],0);
                check_less_or_equal(function__,"skeleton[k0__]",skeleton[k0__],1);
            }
            check_greater_or_equal(function__,"num_patients",num_patients,0);
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"tox[k0__]",tox[k0__],0);
                check_less_or_equal(function__,"tox[k0__]",tox[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"doses[k0__]",doses[k0__],1);
                check_less_or_equal(function__,"doses[k0__]",doses[k0__],num_doses);
            }
            // initialize data variables
            validate_non_negative_index("codified_doses", "num_doses", num_doses);
            codified_doses = std::vector<double>(num_doses,double(0));
            stan::math::fill(codified_doses,DUMMY_VAR__);

            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(codified_doses,i,"codified_doses",1), ((logit(get_base1(skeleton,i,"skeleton",1)) - a0) / (beta_shape / beta_inverse_scale)));
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_CrmOneParamLogisticGammaPrior() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();


            // transformed parameters
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<T__> prob_tox(num_doses);
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), inv_logit((a0 + (beta * get_base1(codified_doses,i,"codified_doses",1)))));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(prob_tox[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_tox" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // model body

            lp_accum__.add(gamma_log(beta,beta_shape,beta_inverse_scale));
            lp_accum__.add(log_joint_pdf(num_patients,tox,doses,codified_doses,a0,beta, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("prob_tox");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_patients);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_CrmOneParamLogisticGammaPrior_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta = in__.scalar_constrain();
        vars__.push_back(beta);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<double> prob_tox(num_doses, 0.0);
            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), inv_logit((a0 + (beta * get_base1(codified_doses,i,"codified_doses",1)))));
            }

            // validate transformed parameters
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(prob_tox[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            validate_non_negative_index("log_lik", "num_patients", num_patients);
            vector_d log_lik(static_cast<Eigen::VectorXd::Index>(num_patients));
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(log_lik,DUMMY_VAR__);


            for (int j = 1; j <= num_patients; ++j) {
                {
                double p_j(0.0);
                (void) p_j;  // dummy to suppress unused var warning

                stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(p_j,DUMMY_VAR__);


                stan::math::assign(p_j, inv_logit((a0 + (beta * get_base1(codified_doses,get_base1(doses,j,"doses",1),"codified_doses",1)))));
                stan::math::assign(get_base1_lhs(log_lik,j,"log_lik",1), log((pow(p_j,get_base1(tox,j,"tox",1)) * pow((1 - p_j),(1 - get_base1(tox,j,"tox",1))))));
                }
            }

            // validate generated quantities

            // write generated quantities
            for (int k_0__ = 0; k_0__ < num_patients; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_CrmOneParamLogisticGammaPrior";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= num_patients; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= num_patients; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_CrmOneParamLogisticNormalPrior_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_CrmOneParamLogisticNormalPrior");
    reader.add_event(95, 95, "end", "model_CrmOneParamLogisticNormalPrior");
    return reader;
}

template <typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T3__, T4__, T5__>::type
log_joint_pdf(const int& num_patients,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const std::vector<T3__>& codified_doses,
                  const T4__& a0,
                  const T5__& beta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        fun_scalar_t__ p;
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);


        stan::math::assign(p, 0);
        for (int j = 1; j <= num_patients; ++j) {
            {
            fun_scalar_t__ prob_tox;
            (void) prob_tox;  // dummy to suppress unused var warning

            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);
            fun_scalar_t__ p_j;
            (void) p_j;  // dummy to suppress unused var warning

            stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p_j,DUMMY_VAR__);


            stan::math::assign(prob_tox, inv_logit((a0 + (exp(beta) * get_base1(codified_doses,get_base1(doses,j,"doses",1),"codified_doses",1)))));
            stan::math::assign(p_j, (pow(prob_tox,get_base1(tox,j,"tox",1)) * pow((1 - prob_tox),(1 - get_base1(tox,j,"tox",1)))));
            stan::math::assign(p, (p + log(p_j)));
            }
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(p);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct log_joint_pdf_functor__ {
    template <typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T3__, T4__, T5__>::type
    operator()(const int& num_patients,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const std::vector<T3__>& codified_doses,
                  const T4__& a0,
                  const T5__& beta, std::ostream* pstream__) const {
        return log_joint_pdf(num_patients, tox, doses, codified_doses, a0, beta, pstream__);
    }
};

class model_CrmOneParamLogisticNormalPrior : public prob_grad {
private:
    double beta_mean;
    double beta_sd;
    int num_doses;
    vector<double> skeleton;
    double a0;
    int num_patients;
    vector<int> tox;
    vector<int> doses;
    vector<double> codified_doses;
public:
    model_CrmOneParamLogisticNormalPrior(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_CrmOneParamLogisticNormalPrior(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_CrmOneParamLogisticNormalPrior_namespace::model_CrmOneParamLogisticNormalPrior";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "beta_mean", "double", context__.to_vec());
            beta_mean = double(0);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            beta_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta_sd", "double", context__.to_vec());
            beta_sd = double(0);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            beta_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_doses", "int", context__.to_vec());
            num_doses = int(0);
            vals_i__ = context__.vals_i("num_doses");
            pos__ = 0;
            num_doses = vals_i__[pos__++];
            validate_non_negative_index("skeleton", "num_doses", num_doses);
            context__.validate_dims("data initialization", "skeleton", "double", context__.to_vec(num_doses));
            validate_non_negative_index("skeleton", "num_doses", num_doses);
            skeleton = std::vector<double>(num_doses,double(0));
            vals_r__ = context__.vals_r("skeleton");
            pos__ = 0;
            size_t skeleton_limit_0__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < skeleton_limit_0__; ++i_0__) {
                skeleton[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "a0", "double", context__.to_vec());
            a0 = double(0);
            vals_r__ = context__.vals_r("a0");
            pos__ = 0;
            a0 = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_patients", "int", context__.to_vec());
            num_patients = int(0);
            vals_i__ = context__.vals_i("num_patients");
            pos__ = 0;
            num_patients = vals_i__[pos__++];
            validate_non_negative_index("tox", "num_patients", num_patients);
            context__.validate_dims("data initialization", "tox", "int", context__.to_vec(num_patients));
            validate_non_negative_index("tox", "num_patients", num_patients);
            tox = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("tox");
            pos__ = 0;
            size_t tox_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < tox_limit_0__; ++i_0__) {
                tox[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("doses", "num_patients", num_patients);
            context__.validate_dims("data initialization", "doses", "int", context__.to_vec(num_patients));
            validate_non_negative_index("doses", "num_patients", num_patients);
            doses = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("doses");
            pos__ = 0;
            size_t doses_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < doses_limit_0__; ++i_0__) {
                doses[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"beta_sd",beta_sd,0);
            check_greater_or_equal(function__,"num_doses",num_doses,1);
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"skeleton[k0__]",skeleton[k0__],0);
                check_less_or_equal(function__,"skeleton[k0__]",skeleton[k0__],1);
            }
            check_greater_or_equal(function__,"num_patients",num_patients,0);
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"tox[k0__]",tox[k0__],0);
                check_less_or_equal(function__,"tox[k0__]",tox[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"doses[k0__]",doses[k0__],1);
                check_less_or_equal(function__,"doses[k0__]",doses[k0__],num_doses);
            }
            // initialize data variables
            validate_non_negative_index("codified_doses", "num_doses", num_doses);
            codified_doses = std::vector<double>(num_doses,double(0));
            stan::math::fill(codified_doses,DUMMY_VAR__);

            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(codified_doses,i,"codified_doses",1), ((logit(get_base1(skeleton,i,"skeleton",1)) - a0) / exp(beta_mean)));
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_CrmOneParamLogisticNormalPrior() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();


            // transformed parameters
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<T__> prob_tox(num_doses);
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), inv_logit((a0 + (exp(beta) * get_base1(codified_doses,i,"codified_doses",1)))));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(prob_tox[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_tox" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // model body

            lp_accum__.add(normal_log(beta,beta_mean,beta_sd));
            lp_accum__.add(log_joint_pdf(num_patients,tox,doses,codified_doses,a0,beta, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("beta");
        names__.push_back("prob_tox");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_patients);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_CrmOneParamLogisticNormalPrior_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double beta = in__.scalar_constrain();
        vars__.push_back(beta);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<double> prob_tox(num_doses, 0.0);
            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), inv_logit((a0 + (exp(beta) * get_base1(codified_doses,i,"codified_doses",1)))));
            }

            // validate transformed parameters
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(prob_tox[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            validate_non_negative_index("log_lik", "num_patients", num_patients);
            vector_d log_lik(static_cast<Eigen::VectorXd::Index>(num_patients));
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(log_lik,DUMMY_VAR__);


            for (int j = 1; j <= num_patients; ++j) {
                {
                double p_j(0.0);
                (void) p_j;  // dummy to suppress unused var warning

                stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(p_j,DUMMY_VAR__);


                stan::math::assign(p_j, inv_logit((a0 + (exp(beta) * get_base1(codified_doses,get_base1(doses,j,"doses",1),"codified_doses",1)))));
                stan::math::assign(get_base1_lhs(log_lik,j,"log_lik",1), log((pow(p_j,get_base1(tox,j,"tox",1)) * pow((1 - p_j),(1 - get_base1(tox,j,"tox",1))))));
                }
            }

            // validate generated quantities

            // write generated quantities
            for (int k_0__ = 0; k_0__ < num_patients; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_CrmOneParamLogisticNormalPrior";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= num_patients; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= num_patients; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_CrmTwoParamLogisticNormalPrior_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_CrmTwoParamLogisticNormalPrior");
    reader.add_event(99, 99, "end", "model_CrmTwoParamLogisticNormalPrior");
    return reader;
}

template <typename T3__, typename T4__, typename T5__>
typename boost::math::tools::promote_args<T3__, T4__, T5__>::type
log_joint_pdf(const int& num_patients,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const std::vector<T3__>& codified_doses,
                  const T4__& alpha,
                  const T5__& beta, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T3__, T4__, T5__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        fun_scalar_t__ p;
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);


        stan::math::assign(p, 0);
        for (int j = 1; j <= num_patients; ++j) {
            {
            fun_scalar_t__ prob_tox;
            (void) prob_tox;  // dummy to suppress unused var warning

            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);
            fun_scalar_t__ p_j;
            (void) p_j;  // dummy to suppress unused var warning

            stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p_j,DUMMY_VAR__);


            stan::math::assign(prob_tox, inv_logit((alpha + (exp(beta) * get_base1(codified_doses,get_base1(doses,j,"doses",1),"codified_doses",1)))));
            stan::math::assign(p_j, (pow(prob_tox,get_base1(tox,j,"tox",1)) * pow((1 - prob_tox),(1 - get_base1(tox,j,"tox",1)))));
            stan::math::assign(p, (p + log(p_j)));
            }
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(p);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct log_joint_pdf_functor__ {
    template <typename T3__, typename T4__, typename T5__>
        typename boost::math::tools::promote_args<T3__, T4__, T5__>::type
    operator()(const int& num_patients,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const std::vector<T3__>& codified_doses,
                  const T4__& alpha,
                  const T5__& beta, std::ostream* pstream__) const {
        return log_joint_pdf(num_patients, tox, doses, codified_doses, alpha, beta, pstream__);
    }
};

class model_CrmTwoParamLogisticNormalPrior : public prob_grad {
private:
    double alpha_mean;
    double alpha_sd;
    double beta_mean;
    double beta_sd;
    int num_doses;
    vector<double> skeleton;
    int num_patients;
    vector<int> tox;
    vector<int> doses;
    vector<double> codified_doses;
public:
    model_CrmTwoParamLogisticNormalPrior(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_CrmTwoParamLogisticNormalPrior(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_CrmTwoParamLogisticNormalPrior_namespace::model_CrmTwoParamLogisticNormalPrior";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "alpha_mean", "double", context__.to_vec());
            alpha_mean = double(0);
            vals_r__ = context__.vals_r("alpha_mean");
            pos__ = 0;
            alpha_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "alpha_sd", "double", context__.to_vec());
            alpha_sd = double(0);
            vals_r__ = context__.vals_r("alpha_sd");
            pos__ = 0;
            alpha_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta_mean", "double", context__.to_vec());
            beta_mean = double(0);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            beta_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta_sd", "double", context__.to_vec());
            beta_sd = double(0);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            beta_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_doses", "int", context__.to_vec());
            num_doses = int(0);
            vals_i__ = context__.vals_i("num_doses");
            pos__ = 0;
            num_doses = vals_i__[pos__++];
            validate_non_negative_index("skeleton", "num_doses", num_doses);
            context__.validate_dims("data initialization", "skeleton", "double", context__.to_vec(num_doses));
            validate_non_negative_index("skeleton", "num_doses", num_doses);
            skeleton = std::vector<double>(num_doses,double(0));
            vals_r__ = context__.vals_r("skeleton");
            pos__ = 0;
            size_t skeleton_limit_0__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < skeleton_limit_0__; ++i_0__) {
                skeleton[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "num_patients", "int", context__.to_vec());
            num_patients = int(0);
            vals_i__ = context__.vals_i("num_patients");
            pos__ = 0;
            num_patients = vals_i__[pos__++];
            validate_non_negative_index("tox", "num_patients", num_patients);
            context__.validate_dims("data initialization", "tox", "int", context__.to_vec(num_patients));
            validate_non_negative_index("tox", "num_patients", num_patients);
            tox = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("tox");
            pos__ = 0;
            size_t tox_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < tox_limit_0__; ++i_0__) {
                tox[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("doses", "num_patients", num_patients);
            context__.validate_dims("data initialization", "doses", "int", context__.to_vec(num_patients));
            validate_non_negative_index("doses", "num_patients", num_patients);
            doses = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("doses");
            pos__ = 0;
            size_t doses_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < doses_limit_0__; ++i_0__) {
                doses[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"alpha_sd",alpha_sd,0);
            check_greater_or_equal(function__,"beta_sd",beta_sd,0);
            check_greater_or_equal(function__,"num_doses",num_doses,1);
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"skeleton[k0__]",skeleton[k0__],0);
                check_less_or_equal(function__,"skeleton[k0__]",skeleton[k0__],1);
            }
            check_greater_or_equal(function__,"num_patients",num_patients,0);
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"tox[k0__]",tox[k0__],0);
                check_less_or_equal(function__,"tox[k0__]",tox[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"doses[k0__]",doses[k0__],1);
                check_less_or_equal(function__,"doses[k0__]",doses[k0__],num_doses);
            }
            // initialize data variables
            validate_non_negative_index("codified_doses", "num_doses", num_doses);
            codified_doses = std::vector<double>(num_doses,double(0));
            stan::math::fill(codified_doses,DUMMY_VAR__);

            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(codified_doses,i,"codified_doses",1), ((logit(get_base1(skeleton,i,"skeleton",1)) - alpha_mean) / exp(beta_mean)));
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_CrmTwoParamLogisticNormalPrior() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_constrain(lp__);
            else
                alpha = in__.scalar_constrain();

            T__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();


            // transformed parameters
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<T__> prob_tox(num_doses);
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), inv_logit((alpha + (exp(beta) * get_base1(codified_doses,i,"codified_doses",1)))));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(prob_tox[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_tox" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // model body

            lp_accum__.add(normal_log(alpha,alpha_mean,alpha_sd));
            lp_accum__.add(normal_log(beta,beta_mean,beta_sd));
            lp_accum__.add(log_joint_pdf(num_patients,tox,doses,codified_doses,alpha,beta, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("prob_tox");
        names__.push_back("log_lik");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_patients);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_CrmTwoParamLogisticNormalPrior_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double alpha = in__.scalar_constrain();
        double beta = in__.scalar_constrain();
        vars__.push_back(alpha);
        vars__.push_back(beta);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<double> prob_tox(num_doses, 0.0);
            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), inv_logit((alpha + (exp(beta) * get_base1(codified_doses,i,"codified_doses",1)))));
            }

            // validate transformed parameters
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(prob_tox[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities
            validate_non_negative_index("log_lik", "num_patients", num_patients);
            vector_d log_lik(static_cast<Eigen::VectorXd::Index>(num_patients));
            (void) log_lik;  // dummy to suppress unused var warning

            stan::math::initialize(log_lik, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(log_lik,DUMMY_VAR__);


            for (int j = 1; j <= num_patients; ++j) {
                {
                double p_j(0.0);
                (void) p_j;  // dummy to suppress unused var warning

                stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(p_j,DUMMY_VAR__);


                stan::math::assign(p_j, inv_logit((alpha + (exp(beta) * get_base1(codified_doses,get_base1(doses,j,"doses",1),"codified_doses",1)))));
                stan::math::assign(get_base1_lhs(log_lik,j,"log_lik",1), log((pow(p_j,get_base1(tox,j,"tox",1)) * pow((1 - p_j),(1 - get_base1(tox,j,"tox",1))))));
                }
            }

            // validate generated quantities

            // write generated quantities
            for (int k_0__ = 0; k_0__ < num_patients; ++k_0__) {
            vars__.push_back(log_lik[k_0__]);
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_CrmTwoParamLogisticNormalPrior";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= num_patients; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
        for (int k_0__ = 1; k_0__ <= num_patients; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log_lik" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_EffTox_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_EffTox");
    reader.add_event(116, 116, "end", "model_EffTox");
    return reader;
}

template <typename T0__, typename T1__, typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__>
typename boost::math::tools::promote_args<T0__, T1__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T11__>::type>::type
log_joint_pdf(const std::vector<T0__>& coded_doses,
                  const std::vector<T1__>& coded_doses_squ,
                  const int& num_patients,
                  const std::vector<int>& eff,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const T6__& alpha,
                  const T7__& beta,
                  const T8__& gamma,
                  const T9__& zeta,
                  const T10__& eta,
                  const T11__& psi, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T11__>::type>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        fun_scalar_t__ p;
        (void) p;  // dummy to suppress unused var warning

        stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(p,DUMMY_VAR__);


        stan::math::assign(p, 0);
        for (int j = 1; j <= num_patients; ++j) {
            {
            fun_scalar_t__ prob_eff;
            (void) prob_eff;  // dummy to suppress unused var warning

            stan::math::initialize(prob_eff, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_eff,DUMMY_VAR__);
            fun_scalar_t__ prob_tox;
            (void) prob_tox;  // dummy to suppress unused var warning

            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);
            fun_scalar_t__ p_j;
            (void) p_j;  // dummy to suppress unused var warning

            stan::math::initialize(p_j, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p_j,DUMMY_VAR__);


            stan::math::assign(prob_eff, inv_logit(((gamma + (zeta * get_base1(coded_doses,get_base1(doses,j,"doses",1),"coded_doses",1))) + (eta * get_base1(coded_doses_squ,get_base1(doses,j,"doses",1),"coded_doses_squ",1)))));
            stan::math::assign(prob_tox, inv_logit((alpha + (beta * get_base1(coded_doses,get_base1(doses,j,"doses",1),"coded_doses",1)))));
            stan::math::assign(p_j, ((((pow(prob_eff,get_base1(eff,j,"eff",1)) * pow((1 - prob_eff),(1 - get_base1(eff,j,"eff",1)))) * pow(prob_tox,get_base1(tox,j,"tox",1))) * pow((1 - prob_tox),(1 - get_base1(tox,j,"tox",1)))) + ((((((pow(-(1),(get_base1(eff,j,"eff",1) + get_base1(tox,j,"tox",1))) * prob_eff) * prob_tox) * (1 - prob_eff)) * (1 - prob_tox)) * (exp(psi) - 1)) / (exp(psi) + 1))));
            stan::math::assign(p, (p + log(p_j)));
            }
        }
        return stan::math::promote_scalar<fun_return_scalar_t__>(p);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct log_joint_pdf_functor__ {
    template <typename T0__, typename T1__, typename T6__, typename T7__, typename T8__, typename T9__, typename T10__, typename T11__>
        typename boost::math::tools::promote_args<T0__, T1__, T6__, T7__, typename boost::math::tools::promote_args<T8__, T9__, T10__, T11__>::type>::type
    operator()(const std::vector<T0__>& coded_doses,
                  const std::vector<T1__>& coded_doses_squ,
                  const int& num_patients,
                  const std::vector<int>& eff,
                  const std::vector<int>& tox,
                  const std::vector<int>& doses,
                  const T6__& alpha,
                  const T7__& beta,
                  const T8__& gamma,
                  const T9__& zeta,
                  const T10__& eta,
                  const T11__& psi, std::ostream* pstream__) const {
        return log_joint_pdf(coded_doses, coded_doses_squ, num_patients, eff, tox, doses, alpha, beta, gamma, zeta, eta, psi, pstream__);
    }
};

class model_EffTox : public prob_grad {
private:
    double alpha_mean;
    double alpha_sd;
    double beta_mean;
    double beta_sd;
    double gamma_mean;
    double gamma_sd;
    double zeta_mean;
    double zeta_sd;
    double eta_mean;
    double eta_sd;
    double psi_mean;
    double psi_sd;
    int num_doses;
    vector<double> real_doses;
    double p;
    double eff0;
    double tox1;
    double efficacy_hurdle;
    double toxicity_hurdle;
    int num_patients;
    vector<int> eff;
    vector<int> tox;
    vector<int> doses;
    vector<double> coded_doses;
    vector<double> coded_doses_squ;
    double mean_log_dose;
public:
    model_EffTox(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_EffTox(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_EffTox_namespace::model_EffTox";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "alpha_mean", "double", context__.to_vec());
            alpha_mean = double(0);
            vals_r__ = context__.vals_r("alpha_mean");
            pos__ = 0;
            alpha_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "alpha_sd", "double", context__.to_vec());
            alpha_sd = double(0);
            vals_r__ = context__.vals_r("alpha_sd");
            pos__ = 0;
            alpha_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta_mean", "double", context__.to_vec());
            beta_mean = double(0);
            vals_r__ = context__.vals_r("beta_mean");
            pos__ = 0;
            beta_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "beta_sd", "double", context__.to_vec());
            beta_sd = double(0);
            vals_r__ = context__.vals_r("beta_sd");
            pos__ = 0;
            beta_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "gamma_mean", "double", context__.to_vec());
            gamma_mean = double(0);
            vals_r__ = context__.vals_r("gamma_mean");
            pos__ = 0;
            gamma_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "gamma_sd", "double", context__.to_vec());
            gamma_sd = double(0);
            vals_r__ = context__.vals_r("gamma_sd");
            pos__ = 0;
            gamma_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "zeta_mean", "double", context__.to_vec());
            zeta_mean = double(0);
            vals_r__ = context__.vals_r("zeta_mean");
            pos__ = 0;
            zeta_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "zeta_sd", "double", context__.to_vec());
            zeta_sd = double(0);
            vals_r__ = context__.vals_r("zeta_sd");
            pos__ = 0;
            zeta_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "eta_mean", "double", context__.to_vec());
            eta_mean = double(0);
            vals_r__ = context__.vals_r("eta_mean");
            pos__ = 0;
            eta_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "eta_sd", "double", context__.to_vec());
            eta_sd = double(0);
            vals_r__ = context__.vals_r("eta_sd");
            pos__ = 0;
            eta_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "psi_mean", "double", context__.to_vec());
            psi_mean = double(0);
            vals_r__ = context__.vals_r("psi_mean");
            pos__ = 0;
            psi_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "psi_sd", "double", context__.to_vec());
            psi_sd = double(0);
            vals_r__ = context__.vals_r("psi_sd");
            pos__ = 0;
            psi_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_doses", "int", context__.to_vec());
            num_doses = int(0);
            vals_i__ = context__.vals_i("num_doses");
            pos__ = 0;
            num_doses = vals_i__[pos__++];
            validate_non_negative_index("real_doses", "num_doses", num_doses);
            context__.validate_dims("data initialization", "real_doses", "double", context__.to_vec(num_doses));
            validate_non_negative_index("real_doses", "num_doses", num_doses);
            real_doses = std::vector<double>(num_doses,double(0));
            vals_r__ = context__.vals_r("real_doses");
            pos__ = 0;
            size_t real_doses_limit_0__ = num_doses;
            for (size_t i_0__ = 0; i_0__ < real_doses_limit_0__; ++i_0__) {
                real_doses[i_0__] = vals_r__[pos__++];
            }
            context__.validate_dims("data initialization", "p", "double", context__.to_vec());
            p = double(0);
            vals_r__ = context__.vals_r("p");
            pos__ = 0;
            p = vals_r__[pos__++];
            context__.validate_dims("data initialization", "eff0", "double", context__.to_vec());
            eff0 = double(0);
            vals_r__ = context__.vals_r("eff0");
            pos__ = 0;
            eff0 = vals_r__[pos__++];
            context__.validate_dims("data initialization", "tox1", "double", context__.to_vec());
            tox1 = double(0);
            vals_r__ = context__.vals_r("tox1");
            pos__ = 0;
            tox1 = vals_r__[pos__++];
            context__.validate_dims("data initialization", "efficacy_hurdle", "double", context__.to_vec());
            efficacy_hurdle = double(0);
            vals_r__ = context__.vals_r("efficacy_hurdle");
            pos__ = 0;
            efficacy_hurdle = vals_r__[pos__++];
            context__.validate_dims("data initialization", "toxicity_hurdle", "double", context__.to_vec());
            toxicity_hurdle = double(0);
            vals_r__ = context__.vals_r("toxicity_hurdle");
            pos__ = 0;
            toxicity_hurdle = vals_r__[pos__++];
            context__.validate_dims("data initialization", "num_patients", "int", context__.to_vec());
            num_patients = int(0);
            vals_i__ = context__.vals_i("num_patients");
            pos__ = 0;
            num_patients = vals_i__[pos__++];
            validate_non_negative_index("eff", "num_patients", num_patients);
            context__.validate_dims("data initialization", "eff", "int", context__.to_vec(num_patients));
            validate_non_negative_index("eff", "num_patients", num_patients);
            eff = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("eff");
            pos__ = 0;
            size_t eff_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < eff_limit_0__; ++i_0__) {
                eff[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("tox", "num_patients", num_patients);
            context__.validate_dims("data initialization", "tox", "int", context__.to_vec(num_patients));
            validate_non_negative_index("tox", "num_patients", num_patients);
            tox = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("tox");
            pos__ = 0;
            size_t tox_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < tox_limit_0__; ++i_0__) {
                tox[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("doses", "num_patients", num_patients);
            context__.validate_dims("data initialization", "doses", "int", context__.to_vec(num_patients));
            validate_non_negative_index("doses", "num_patients", num_patients);
            doses = std::vector<int>(num_patients,int(0));
            vals_i__ = context__.vals_i("doses");
            pos__ = 0;
            size_t doses_limit_0__ = num_patients;
            for (size_t i_0__ = 0; i_0__ < doses_limit_0__; ++i_0__) {
                doses[i_0__] = vals_i__[pos__++];
            }

            // validate, data variables
            check_greater_or_equal(function__,"alpha_sd",alpha_sd,0);
            check_greater_or_equal(function__,"beta_sd",beta_sd,0);
            check_greater_or_equal(function__,"gamma_sd",gamma_sd,0);
            check_greater_or_equal(function__,"zeta_sd",zeta_sd,0);
            check_greater_or_equal(function__,"eta_sd",eta_sd,0);
            check_greater_or_equal(function__,"psi_sd",psi_sd,0);
            check_greater_or_equal(function__,"num_doses",num_doses,1);
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"real_doses[k0__]",real_doses[k0__],0);
            }
            check_greater_or_equal(function__,"num_patients",num_patients,0);
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"eff[k0__]",eff[k0__],0);
                check_less_or_equal(function__,"eff[k0__]",eff[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"tox[k0__]",tox[k0__],0);
                check_less_or_equal(function__,"tox[k0__]",tox[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_patients; ++k0__) {
                check_greater_or_equal(function__,"doses[k0__]",doses[k0__],1);
                check_less_or_equal(function__,"doses[k0__]",doses[k0__],num_doses);
            }
            // initialize data variables
            validate_non_negative_index("coded_doses", "num_doses", num_doses);
            coded_doses = std::vector<double>(num_doses,double(0));
            stan::math::fill(coded_doses,DUMMY_VAR__);
            validate_non_negative_index("coded_doses_squ", "num_doses", num_doses);
            coded_doses_squ = std::vector<double>(num_doses,double(0));
            stan::math::fill(coded_doses_squ,DUMMY_VAR__);
            mean_log_dose = double(0);
            stan::math::fill(mean_log_dose,DUMMY_VAR__);

            stan::math::assign(mean_log_dose, 0.0);
            for (int i = 1; i <= num_doses; ++i) {
                stan::math::assign(mean_log_dose, (mean_log_dose + log(get_base1(real_doses,i,"real_doses",1))));
            }
            stan::math::assign(mean_log_dose, (mean_log_dose / num_doses));
            for (int i = 1; i <= num_doses; ++i) {

                stan::math::assign(get_base1_lhs(coded_doses,i,"coded_doses",1), (log(get_base1(real_doses,i,"real_doses",1)) - mean_log_dose));
                stan::math::assign(get_base1_lhs(coded_doses_squ,i,"coded_doses_squ",1), pow(get_base1(coded_doses,i,"coded_doses",1),2));
            }

            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
            ++num_params_r__;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_EffTox() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec());
        double alpha(0);
        alpha = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(alpha);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("beta")))
            throw std::runtime_error("variable beta missing");
        vals_r__ = context__.vals_r("beta");
        pos__ = 0U;
        context__.validate_dims("initialization", "beta", "double", context__.to_vec());
        double beta(0);
        beta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(beta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable beta: ") + e.what());
        }

        if (!(context__.contains_r("gamma")))
            throw std::runtime_error("variable gamma missing");
        vals_r__ = context__.vals_r("gamma");
        pos__ = 0U;
        context__.validate_dims("initialization", "gamma", "double", context__.to_vec());
        double gamma(0);
        gamma = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(gamma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable gamma: ") + e.what());
        }

        if (!(context__.contains_r("zeta")))
            throw std::runtime_error("variable zeta missing");
        vals_r__ = context__.vals_r("zeta");
        pos__ = 0U;
        context__.validate_dims("initialization", "zeta", "double", context__.to_vec());
        double zeta(0);
        zeta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(zeta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable zeta: ") + e.what());
        }

        if (!(context__.contains_r("eta")))
            throw std::runtime_error("variable eta missing");
        vals_r__ = context__.vals_r("eta");
        pos__ = 0U;
        context__.validate_dims("initialization", "eta", "double", context__.to_vec());
        double eta(0);
        eta = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(eta);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable eta: ") + e.what());
        }

        if (!(context__.contains_r("psi")))
            throw std::runtime_error("variable psi missing");
        vals_r__ = context__.vals_r("psi");
        pos__ = 0U;
        context__.validate_dims("initialization", "psi", "double", context__.to_vec());
        double psi(0);
        psi = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(psi);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable psi: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ alpha;
            (void) alpha;  // dummy to suppress unused var warning
            if (jacobian__)
                alpha = in__.scalar_constrain(lp__);
            else
                alpha = in__.scalar_constrain();

            T__ beta;
            (void) beta;  // dummy to suppress unused var warning
            if (jacobian__)
                beta = in__.scalar_constrain(lp__);
            else
                beta = in__.scalar_constrain();

            T__ gamma;
            (void) gamma;  // dummy to suppress unused var warning
            if (jacobian__)
                gamma = in__.scalar_constrain(lp__);
            else
                gamma = in__.scalar_constrain();

            T__ zeta;
            (void) zeta;  // dummy to suppress unused var warning
            if (jacobian__)
                zeta = in__.scalar_constrain(lp__);
            else
                zeta = in__.scalar_constrain();

            T__ eta;
            (void) eta;  // dummy to suppress unused var warning
            if (jacobian__)
                eta = in__.scalar_constrain(lp__);
            else
                eta = in__.scalar_constrain();

            T__ psi;
            (void) psi;  // dummy to suppress unused var warning
            if (jacobian__)
                psi = in__.scalar_constrain(lp__);
            else
                psi = in__.scalar_constrain();


            // transformed parameters
            validate_non_negative_index("prob_eff", "num_doses", num_doses);
            vector<T__> prob_eff(num_doses);
            stan::math::initialize(prob_eff, DUMMY_VAR__);
            stan::math::fill(prob_eff,DUMMY_VAR__);
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<T__> prob_tox(num_doses);
            stan::math::initialize(prob_tox, DUMMY_VAR__);
            stan::math::fill(prob_tox,DUMMY_VAR__);
            validate_non_negative_index("prob_acc_eff", "num_doses", num_doses);
            vector<T__> prob_acc_eff(num_doses);
            stan::math::initialize(prob_acc_eff, DUMMY_VAR__);
            stan::math::fill(prob_acc_eff,DUMMY_VAR__);
            validate_non_negative_index("prob_acc_tox", "num_doses", num_doses);
            vector<T__> prob_acc_tox(num_doses);
            stan::math::initialize(prob_acc_tox, DUMMY_VAR__);
            stan::math::fill(prob_acc_tox,DUMMY_VAR__);
            validate_non_negative_index("utility", "num_doses", num_doses);
            vector<T__> utility(num_doses);
            stan::math::initialize(utility, DUMMY_VAR__);
            stan::math::fill(utility,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {
                {
                T__ r_to_the_p;
                (void) r_to_the_p;  // dummy to suppress unused var warning

                stan::math::initialize(r_to_the_p, DUMMY_VAR__);
                stan::math::fill(r_to_the_p,DUMMY_VAR__);


                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), inv_logit((alpha + (beta * get_base1(coded_doses,i,"coded_doses",1)))));
                stan::math::assign(get_base1_lhs(prob_eff,i,"prob_eff",1), inv_logit(((gamma + (zeta * get_base1(coded_doses,i,"coded_doses",1))) + (eta * get_base1(coded_doses_squ,i,"coded_doses_squ",1)))));
                stan::math::assign(get_base1_lhs(prob_acc_eff,i,"prob_acc_eff",1), int_step((get_base1(prob_eff,i,"prob_eff",1) - efficacy_hurdle)));
                stan::math::assign(get_base1_lhs(prob_acc_tox,i,"prob_acc_tox",1), int_step((toxicity_hurdle - get_base1(prob_tox,i,"prob_tox",1))));
                stan::math::assign(r_to_the_p, (pow(((1 - get_base1(prob_eff,i,"prob_eff",1)) / (1 - eff0)),p) + pow((get_base1(prob_tox,i,"prob_tox",1) / tox1),p)));
                stan::math::assign(get_base1_lhs(utility,i,"utility",1), (1 - pow(r_to_the_p,(1.0 / p))));
                }
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(prob_eff[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_eff" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(prob_tox[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_tox" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(prob_acc_eff[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_acc_eff" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(prob_acc_tox[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: prob_acc_tox" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < num_doses; ++i0__) {
                if (stan::math::is_uninitialized(utility[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: utility" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_eff[k0__]",prob_eff[k0__],0);
                check_less_or_equal(function__,"prob_eff[k0__]",prob_eff[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_acc_eff[k0__]",prob_acc_eff[k0__],0);
                check_less_or_equal(function__,"prob_acc_eff[k0__]",prob_acc_eff[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_acc_tox[k0__]",prob_acc_tox[k0__],0);
                check_less_or_equal(function__,"prob_acc_tox[k0__]",prob_acc_tox[k0__],1);
            }

            // model body

            lp_accum__.add(normal_log(alpha,alpha_mean,alpha_sd));
            lp_accum__.add(normal_log(beta,beta_mean,beta_sd));
            lp_accum__.add(normal_log(gamma,gamma_mean,gamma_sd));
            lp_accum__.add(normal_log(zeta,zeta_mean,zeta_sd));
            lp_accum__.add(normal_log(eta,eta_mean,eta_sd));
            lp_accum__.add(normal_log(psi,psi_mean,psi_sd));
            lp_accum__.add(log_joint_pdf(coded_doses,coded_doses_squ,num_patients,eff,tox,doses,alpha,beta,gamma,zeta,eta,psi, pstream__));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("beta");
        names__.push_back("gamma");
        names__.push_back("zeta");
        names__.push_back("eta");
        names__.push_back("psi");
        names__.push_back("prob_eff");
        names__.push_back("prob_tox");
        names__.push_back("prob_acc_eff");
        names__.push_back("prob_acc_tox");
        names__.push_back("utility");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(num_doses);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_EffTox_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double alpha = in__.scalar_constrain();
        double beta = in__.scalar_constrain();
        double gamma = in__.scalar_constrain();
        double zeta = in__.scalar_constrain();
        double eta = in__.scalar_constrain();
        double psi = in__.scalar_constrain();
        vars__.push_back(alpha);
        vars__.push_back(beta);
        vars__.push_back(gamma);
        vars__.push_back(zeta);
        vars__.push_back(eta);
        vars__.push_back(psi);

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("prob_eff", "num_doses", num_doses);
            vector<double> prob_eff(num_doses, 0.0);
            stan::math::initialize(prob_eff, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_eff,DUMMY_VAR__);
            validate_non_negative_index("prob_tox", "num_doses", num_doses);
            vector<double> prob_tox(num_doses, 0.0);
            stan::math::initialize(prob_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_tox,DUMMY_VAR__);
            validate_non_negative_index("prob_acc_eff", "num_doses", num_doses);
            vector<double> prob_acc_eff(num_doses, 0.0);
            stan::math::initialize(prob_acc_eff, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_acc_eff,DUMMY_VAR__);
            validate_non_negative_index("prob_acc_tox", "num_doses", num_doses);
            vector<double> prob_acc_tox(num_doses, 0.0);
            stan::math::initialize(prob_acc_tox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(prob_acc_tox,DUMMY_VAR__);
            validate_non_negative_index("utility", "num_doses", num_doses);
            vector<double> utility(num_doses, 0.0);
            stan::math::initialize(utility, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(utility,DUMMY_VAR__);


            for (int i = 1; i <= num_doses; ++i) {
                {
                double r_to_the_p(0.0);
                (void) r_to_the_p;  // dummy to suppress unused var warning

                stan::math::initialize(r_to_the_p, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(r_to_the_p,DUMMY_VAR__);


                stan::math::assign(get_base1_lhs(prob_tox,i,"prob_tox",1), inv_logit((alpha + (beta * get_base1(coded_doses,i,"coded_doses",1)))));
                stan::math::assign(get_base1_lhs(prob_eff,i,"prob_eff",1), inv_logit(((gamma + (zeta * get_base1(coded_doses,i,"coded_doses",1))) + (eta * get_base1(coded_doses_squ,i,"coded_doses_squ",1)))));
                stan::math::assign(get_base1_lhs(prob_acc_eff,i,"prob_acc_eff",1), int_step((get_base1(prob_eff,i,"prob_eff",1) - efficacy_hurdle)));
                stan::math::assign(get_base1_lhs(prob_acc_tox,i,"prob_acc_tox",1), int_step((toxicity_hurdle - get_base1(prob_tox,i,"prob_tox",1))));
                stan::math::assign(r_to_the_p, (pow(((1 - get_base1(prob_eff,i,"prob_eff",1)) / (1 - eff0)),p) + pow((get_base1(prob_tox,i,"prob_tox",1) / tox1),p)));
                stan::math::assign(get_base1_lhs(utility,i,"utility",1), (1 - pow(r_to_the_p,(1.0 / p))));
                }
            }

            // validate transformed parameters
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_eff[k0__]",prob_eff[k0__],0);
                check_less_or_equal(function__,"prob_eff[k0__]",prob_eff[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],0);
                check_less_or_equal(function__,"prob_tox[k0__]",prob_tox[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_acc_eff[k0__]",prob_acc_eff[k0__],0);
                check_less_or_equal(function__,"prob_acc_eff[k0__]",prob_acc_eff[k0__],1);
            }
            for (int k0__ = 0; k0__ < num_doses; ++k0__) {
                check_greater_or_equal(function__,"prob_acc_tox[k0__]",prob_acc_tox[k0__],0);
                check_less_or_equal(function__,"prob_acc_tox[k0__]",prob_acc_tox[k0__],1);
            }

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(prob_eff[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(prob_tox[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(prob_acc_eff[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(prob_acc_tox[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < num_doses; ++k_0__) {
            vars__.push_back(utility[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_EffTox";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_eff" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_acc_eff" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_acc_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "utility" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "alpha";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "beta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "gamma";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "zeta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "eta";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "psi";
        param_names__.push_back(param_name_stream__.str());

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_eff" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_acc_eff" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "prob_acc_tox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= num_doses; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "utility" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_ThallHierarchicalBinary_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_ThallHierarchicalBinary");
    reader.add_event(50, 50, "end", "model_ThallHierarchicalBinary");
    return reader;
}

class model_ThallHierarchicalBinary : public prob_grad {
private:
    int m;
    vector<int> x;
    vector<int> n;
    double target_resp;
    double mu_mean;
    double mu_sd;
    double tau_alpha;
    double tau_beta;
public:
    model_ThallHierarchicalBinary(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_ThallHierarchicalBinary(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_ThallHierarchicalBinary_namespace::model_ThallHierarchicalBinary";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            context__.validate_dims("data initialization", "m", "int", context__.to_vec());
            m = int(0);
            vals_i__ = context__.vals_i("m");
            pos__ = 0;
            m = vals_i__[pos__++];
            validate_non_negative_index("x", "m", m);
            context__.validate_dims("data initialization", "x", "int", context__.to_vec(m));
            validate_non_negative_index("x", "m", m);
            x = std::vector<int>(m,int(0));
            vals_i__ = context__.vals_i("x");
            pos__ = 0;
            size_t x_limit_0__ = m;
            for (size_t i_0__ = 0; i_0__ < x_limit_0__; ++i_0__) {
                x[i_0__] = vals_i__[pos__++];
            }
            validate_non_negative_index("n", "m", m);
            context__.validate_dims("data initialization", "n", "int", context__.to_vec(m));
            validate_non_negative_index("n", "m", m);
            n = std::vector<int>(m,int(0));
            vals_i__ = context__.vals_i("n");
            pos__ = 0;
            size_t n_limit_0__ = m;
            for (size_t i_0__ = 0; i_0__ < n_limit_0__; ++i_0__) {
                n[i_0__] = vals_i__[pos__++];
            }
            context__.validate_dims("data initialization", "target_resp", "double", context__.to_vec());
            target_resp = double(0);
            vals_r__ = context__.vals_r("target_resp");
            pos__ = 0;
            target_resp = vals_r__[pos__++];
            context__.validate_dims("data initialization", "mu_mean", "double", context__.to_vec());
            mu_mean = double(0);
            vals_r__ = context__.vals_r("mu_mean");
            pos__ = 0;
            mu_mean = vals_r__[pos__++];
            context__.validate_dims("data initialization", "mu_sd", "double", context__.to_vec());
            mu_sd = double(0);
            vals_r__ = context__.vals_r("mu_sd");
            pos__ = 0;
            mu_sd = vals_r__[pos__++];
            context__.validate_dims("data initialization", "tau_alpha", "double", context__.to_vec());
            tau_alpha = double(0);
            vals_r__ = context__.vals_r("tau_alpha");
            pos__ = 0;
            tau_alpha = vals_r__[pos__++];
            context__.validate_dims("data initialization", "tau_beta", "double", context__.to_vec());
            tau_beta = double(0);
            vals_r__ = context__.vals_r("tau_beta");
            pos__ = 0;
            tau_beta = vals_r__[pos__++];

            // validate, data variables
            check_greater_or_equal(function__,"m",m,1);
            for (int k0__ = 0; k0__ < m; ++k0__) {
                check_greater_or_equal(function__,"x[k0__]",x[k0__],0);
            }
            for (int k0__ = 0; k0__ < m; ++k0__) {
                check_greater_or_equal(function__,"n[k0__]",n[k0__],0);
            }
            check_greater_or_equal(function__,"target_resp",target_resp,0.0);
            check_less_or_equal(function__,"target_resp",target_resp,1.0);
            check_greater_or_equal(function__,"mu_sd",mu_sd,0.0);
            check_greater_or_equal(function__,"tau_alpha",tau_alpha,0);
            check_greater_or_equal(function__,"tau_beta",tau_beta,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            ++num_params_r__;
            ++num_params_r__;
            validate_non_negative_index("rho", "m", m);
            num_params_r__ += m;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_ThallHierarchicalBinary() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("mu")))
            throw std::runtime_error("variable mu missing");
        vals_r__ = context__.vals_r("mu");
        pos__ = 0U;
        context__.validate_dims("initialization", "mu", "double", context__.to_vec());
        double mu(0);
        mu = vals_r__[pos__++];
        try {
            writer__.scalar_unconstrain(mu);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable mu: ") + e.what());
        }

        if (!(context__.contains_r("sigma")))
            throw std::runtime_error("variable sigma missing");
        vals_r__ = context__.vals_r("sigma");
        pos__ = 0U;
        context__.validate_dims("initialization", "sigma", "double", context__.to_vec());
        double sigma(0);
        sigma = vals_r__[pos__++];
        try {
            writer__.scalar_lb_unconstrain(0.0,sigma);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable sigma: ") + e.what());
        }

        if (!(context__.contains_r("rho")))
            throw std::runtime_error("variable rho missing");
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "m", m);
        context__.validate_dims("initialization", "rho", "double", context__.to_vec(m));
        std::vector<double> rho(m,double(0));
        for (int i0__ = 0U; i0__ < m; ++i0__)
            rho[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < m; ++i0__)
            try {
            writer__.scalar_unconstrain(rho[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            T__ mu;
            (void) mu;  // dummy to suppress unused var warning
            if (jacobian__)
                mu = in__.scalar_constrain(lp__);
            else
                mu = in__.scalar_constrain();

            T__ sigma;
            (void) sigma;  // dummy to suppress unused var warning
            if (jacobian__)
                sigma = in__.scalar_lb_constrain(0.0,lp__);
            else
                sigma = in__.scalar_lb_constrain(0.0);

            vector<T__> rho;
            size_t dim_rho_0__ = m;
            rho.reserve(dim_rho_0__);
            for (size_t k_0__ = 0; k_0__ < dim_rho_0__; ++k_0__) {
                if (jacobian__)
                    rho.push_back(in__.scalar_constrain(lp__));
                else
                    rho.push_back(in__.scalar_constrain());
            }


            // transformed parameters
            validate_non_negative_index("p", "m", m);
            vector<T__> p(m);
            stan::math::initialize(p, DUMMY_VAR__);
            stan::math::fill(p,DUMMY_VAR__);
            validate_non_negative_index("pg", "m", m);
            vector<T__> pg(m);
            stan::math::initialize(pg, DUMMY_VAR__);
            stan::math::fill(pg,DUMMY_VAR__);


            for (int i = 1; i <= m; ++i) {

                stan::math::assign(get_base1_lhs(p,i,"p",1), inv_logit(get_base1(rho,i,"rho",1)));
                stan::math::assign(get_base1_lhs(pg,i,"pg",1), int_step((get_base1(p,i,"p",1) - target_resp)));
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < m; ++i0__) {
                if (stan::math::is_uninitialized(p[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: p" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < m; ++i0__) {
                if (stan::math::is_uninitialized(pg[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: pg" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            for (int k0__ = 0; k0__ < m; ++k0__) {
                check_greater_or_equal(function__,"p[k0__]",p[k0__],0.0);
                check_less_or_equal(function__,"p[k0__]",p[k0__],1.0);
            }
            for (int k0__ = 0; k0__ < m; ++k0__) {
                check_greater_or_equal(function__,"pg[k0__]",pg[k0__],0);
                check_less_or_equal(function__,"pg[k0__]",pg[k0__],1);
            }

            // model body

            lp_accum__.add(normal_log<propto__>(mu, mu_mean, mu_sd));
            lp_accum__.add(inv_gamma_log<propto__>(sigma, tau_alpha, tau_beta));
            lp_accum__.add(normal_log<propto__>(rho, mu, sigma));
            lp_accum__.add(binomial_logit_log<propto__>(x, n, rho));

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("mu");
        names__.push_back("sigma");
        names__.push_back("rho");
        names__.push_back("p");
        names__.push_back("pg");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(m);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_ThallHierarchicalBinary_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double mu = in__.scalar_constrain();
        double sigma = in__.scalar_lb_constrain(0.0);
        vector<double> rho;
        size_t dim_rho_0__ = m;
        for (size_t k_0__ = 0; k_0__ < dim_rho_0__; ++k_0__) {
            rho.push_back(in__.scalar_constrain());
        }
        vars__.push_back(mu);
        vars__.push_back(sigma);
            for (int k_0__ = 0; k_0__ < m; ++k_0__) {
            vars__.push_back(rho[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            validate_non_negative_index("p", "m", m);
            vector<double> p(m, 0.0);
            stan::math::initialize(p, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(p,DUMMY_VAR__);
            validate_non_negative_index("pg", "m", m);
            vector<double> pg(m, 0.0);
            stan::math::initialize(pg, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(pg,DUMMY_VAR__);


            for (int i = 1; i <= m; ++i) {

                stan::math::assign(get_base1_lhs(p,i,"p",1), inv_logit(get_base1(rho,i,"rho",1)));
                stan::math::assign(get_base1_lhs(pg,i,"pg",1), int_step((get_base1(p,i,"p",1) - target_resp)));
            }

            // validate transformed parameters
            for (int k0__ = 0; k0__ < m; ++k0__) {
                check_greater_or_equal(function__,"p[k0__]",p[k0__],0.0);
                check_less_or_equal(function__,"p[k0__]",p[k0__],1.0);
            }
            for (int k0__ = 0; k0__ < m; ++k0__) {
                check_greater_or_equal(function__,"pg[k0__]",pg[k0__],0);
                check_less_or_equal(function__,"pg[k0__]",pg[k0__],1);
            }

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < m; ++k_0__) {
            vars__.push_back(p[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < m; ++k_0__) {
            vars__.push_back(pg[k_0__]);
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_ThallHierarchicalBinary";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= m; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= m; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= m; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pg" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        param_name_stream__.str(std::string());
        param_name_stream__ << "mu";
        param_names__.push_back(param_name_stream__.str());
        param_name_stream__.str(std::string());
        param_name_stream__ << "sigma";
        param_names__.push_back(param_name_stream__.str());
        for (int k_0__ = 1; k_0__ <= m; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= m; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "p" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= m; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pg" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__) return;
    }

}; // model

}




#endif
