% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CRM.R
\name{stan_crm}
\alias{stan_crm}
\title{Fit a CRM model}
\usage{
stan_crm(outcome_str = NULL, skeleton, target, model = c("empiric",
  "logistic", "logistic_gamma", "logistic2"), a0 = NULL, alpha_mean = NULL,
  alpha_sd = NULL, beta_mean = NULL, beta_sd = NULL, beta_shape = NULL,
  beta_inverse_scale = NULL, doses_given = NULL, tox = NULL, ...)
}
\arguments{
\item{outcome_str}{A string representing the outcomes observed hitherto.
See \code{\link{df_parse_outcomes}} for a description of syntax and
examples. Alternatively, you may provide \code{doses_given} and \code{tox}
parameters. See Details.}

\item{skeleton}{a vector of the prior guesses of toxicity at doses.
This should be a monotonically-increasing vector of numbers between 0 and 1.}

\item{target}{the target toxicity probability, a number between 0 and 1.
This value would normally be one of the values in \code{skeleton}, but that
is not a requirement.}

\item{model}{Character string to denote desired model. One of \code{empiric},
\code{logistic}, \code{logistic_gamma}, or \code{logistic2}.
The choice of model determines which parameters are required. See Details.}

\item{a0}{Value of fixed intercept parameter.
Only required for certain models. See Details.}

\item{alpha_mean}{Prior mean of intercept variable for normal prior.
Only required for certain models. See Details.}

\item{alpha_sd}{Prior standard deviation of intercept variable for normal prior.
Only required for certain models. See Details.}

\item{beta_mean}{Prior mean of gradient variable for normal prior.
Only required for certain models. See Details.}

\item{beta_sd}{Prior standard deviation of slope variable for normal prior.
Only required for certain models. See Details.}

\item{beta_shape}{Prior shape parameter of slope variable for gamma prior.
Only required for certain models. See Details.}

\item{beta_inverse_scale}{Prior inverse scale parameter of slope variable for
gamma prior. Only required for certain models. See Details.}

\item{doses_given}{A optional vector of dose-levels given to patients
1:num_patients, where 1=lowest dose, 2=second dose, etc. Only required when
\code{outcome_str} is not provided.}

\item{tox}{An optional vector of toxicity outcomes for patients
1:num_patients, where 1=toxicity and 0=no toxicity. Only required when
\code{outcome_str} is not provided.}

\item{...}{Extra parameters are passed to \code{rstan::sampling}. Commonly
used options are \code{iter}, \code{chains}, \code{warmup}, \code{cores},
\code{control}. \code{\link[rstan:sampling]{sampling}}.}
}
\value{
An object of class \code{\link{crm_fit}}
}
\description{
Fit a CRM model using Stan for full Bayesian inference.
}
\details{
The quickest and easiest way to fit a CRM model to some observed outcomes
is to describe the outcomes using \pkg{trialr}'s syntax for dose-finding
outcomes. See \code{\link{df_parse_outcomes}} for full details and examples.

Different model parameterisations require that difference parameter values
are specified.
}
\section{Requirements of \code{empiric} model}{

* beta_sd
}

\section{Requirements of \code{logistic} model}{

* a0
* beta_mean
* beta_sd
}

\section{Requirements of \code{logistic_gamma} model}{

* a0
* beta_shape
* beta_inverse_scale
}

\section{Requirements of \code{logistics} model}{

* a0
* alpha_mean
* alpha_sd
* beta_mean
* beta_sd
}

\examples{
\dontrun{
# This model is presented in Thall et al. (2014)
mod1 <- stan_crm('1N 2N 3T', skeleton = c(0.1, 0.2, 0.35, 0.6),
                 target = 0.2, model = 'empiric', beta_sd = sqrt(1.34),
                 seed = 123)

# Shorthand for the above is:
mod2 <- stan_efftox_demo('1N 2E 3B', seed = 123)

# the seed is passed to the Stan sampler. The usual Stan sampler params like
# cores, iter, chains etc are passed on too via the ellipsis operator.
}
}
\references{
O'Quigley, J., Pepe, M., & Fisher, L. (1990).
  Continual reassessment method: a practical design for phase 1 clinical
  trials in cancer.
  Biometrics, 46(1), 33-48. https://doi.org/10.2307/2531628
}
\seealso{
\code{\link{crm_fit}}
  \code{\link{crm_process}}
}
\author{
Kristian Brock \email{kristian.brock@gmail.com}
}
