% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boxcoxROC.R
\name{boxcoxROC}
\alias{boxcoxROC}
\title{Box-Cox transformation on three-class ROC data}
\usage{
boxcoxROC(
  x,
  y,
  z,
  lambda = seq(-2, 2, 0.05),
  lambda2 = NULL,
  eps = 0.02,
  verbose = TRUE
)
}
\arguments{
\item{x, y, z}{vectors containing the data of the three classes "healthy",
"intermediate" and "diseased" to be transformed. In two-class ROC analysis only.}

\item{lambda}{vector of possible lambdas the log-likelihood function is evaluated.}

\item{lambda2}{numeric shifting parameter. For the implemented Box-Cox
transformation positive measurements in \code{x, y, z} are required.
\code{lambda2} is used to shift these measurements.}

\item{eps}{numeric; indicating the bandwith around zero, where \code{lambda}
is treated to be zero and the data is log-transformed.}

\item{verbose}{logical; indicating whether output should be displayed (default) or
not.}
}
\value{
A list with  components:
  \item{xbc, ybc, zbc}{The transformed vectors.}
  \item{lambda}{estimated optimal parameter.}
  \item{shapiro.p.value}{p-values obtained from \code{shapiro.test()} of
  the original and transformed data.}
}
\description{
A transformation function for three-class ROC data in order to obtain normally
distributed classes.
}
\details{
A Box-Cox transformation computing

\deqn{X^{(\lambda)} = \left\{ \begin{array}{ll} (X^\lambda -1)/\lambda, 	&
\mbox{if } \; \lambda \neq 0,\\ \log(X),	& \mbox{else } \; \lambda = 0,
\end{array} \right.}{X^{(\lambda)} = log(X) if \lambda = 0 and X^{(\lambda)}
= (X^\lambda -1)/\lambda otherwise}

with optimal \eqn{\lambda} estimated from the likelihood kernel function,
as formally described in the supplementary
material in Bantis et al. (2017). If the data include any nonpositive
observations, a shifting parameter \code{lambda2} can be included in the
transformation given by:

\deqn{X^{(\lambda)} = \left\{ \begin{array}{ll} ((X+\lambda_2)^\lambda -1)/\lambda, &	\mbox{if }
\, \lambda \neq 0,\\ \log(X+\lambda_2),	& \mbox{else } \; \lambda = 0. \end{array}
\right.\\
}{X^{(\lambda)} = log(X+\lambda_2), if \lambda = 0
 and X^{(\lambda)} =  ((X+\lambda_2)^\lambda -1)/\lambda
 otherwise.
}
}
\examples{
data(cancer)
x1 <- with(cancer, cancer[trueClass=="healthy", 9])
y1 <- with(cancer, cancer[trueClass=="intermediate", 9])
z1 <- with(cancer, cancer[trueClass=="diseased", 9])

boxcoxROC(x1, y1, z1)
}
\references{
Bantis LE, Nakas CT, Reiser B, Myall D and Dalrymple-Alford JC
  (2015) Construction of joint confidence regions for the optimal true class
  fractions of receiver operating characteristic (roc) surfaces and
  manifolds. \emph{Statistical Methods in Medical Research} \bold{26}(3): 1429–1442.

Box, G. E. P. and Cox, D. R.  (1964). An analysis of
  transformations (with discussion). \emph{Journal of the Royal Statistical Society,
  Series B}, \bold{26}, 211–252.
}
\seealso{
\code{\link{shapiro.test}} and \code{\link[MASS:boxcox]{boxcox}} from the package \code{MASS}.
}
