context("test-distances")

test_that("distance gives comparable values", {
  expect_equivalent(as.numeric(round(quantile(trackDistance(walrus818)))), c(0, 98, 445, 1433, 309075))
  
  expect_equivalent(round(homedist(walrus818)), 
                    c(`353` = 194120, `354` = 515916, `355` = 513436, `356` = 516914, 
                      `357` = 519706, `358` = 515748, `359` = 514025, `361` = 512403, 
                      `362` = 199096, `366` = 516366, `367` = 63337, `368` = 510726, 
                      `443` = 518193, `444` = 454477)
                    
                    
  )
  expect_equivalent( round(homedist(walrus818, cbind(0, 0))), 
                     c(`353` = 284118, `354` = 359920, `355` = 354514, `356` = 412693, 
                       `357` = 374616, `358` = 369769, `359` = 356057, `361` = 354525, 
                       `362` = 310850, `366` = 356839, `367` = 313050, `368` = 353936, 
                       `443` = 371292, `444` = 289451)
  )
  
  wll <- sp::spTransform(walrus818, "+proj=longlat +datum=WGS84")
  expect_equivalent(round(homedist(wll), digits = 2), 
                    c(`353` = 193.59, `354` = 514.57, `355` = 512.07, `356` = 515.58, 
                      `357` = 518.37, `358` = 514.42, `359` = 512.68, `361` = 511.07, 
                      `362` = 198.56, `366` = 515.02, `367` = 63.17, `368` = 509.39, 
                      `443` = 516.86, `444` = 453.26)
                    
  )
  
  expect_equivalent(round(homedist(wll, cbind(0, 0)), digits = 2), 
                    c(`353` = 12301.33, `354` = 12569.03, `355` = 12563.62, `356` = 12612.42, 
                      `357` = 12583.66, `358` = 12578.83, `359` = 12565.11, `361` = 12563.6, 
                      `362` = 12308.49, `366` = 12565.79, `367` = 12102.11, `368` = 12563.07, 
                      `443` = 12580.38, `444` = 12498.77)
                    
                    )
})
