% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triptych_mcbdsc.R
\name{mcbdsc}
\alias{mcbdsc}
\alias{as_mcbdsc}
\title{Evaluation of forecasts using score decompositions}
\usage{
mcbdsc(x, y_var = "y", ..., y = NULL, score = "Brier_score")

as_mcbdsc(x, r)
}
\arguments{
\item{x}{A data frame, list, matrix, or other object that can be coerced to a tibble. Contains numeric forecasts, and observations (optional).}

\item{y_var}{A variable in \code{x} that contains observations. Specified as the argument \code{var}in \code{\link[dplyr:pull]{dplyr::pull()}}.}

\item{...}{Unused.}

\item{y}{A numeric vector of observations. If supplied, overrides \code{y_var}. Otherwise, defaults to \code{dplyr::pull(x, y_var)}.}

\item{score}{A string specifying the score function.
One of: \code{"Brier_score"} (default), \code{"log_score"}, \code{"MR_score"}.}

\item{r}{A reference triptych_mcbdsc object whose attributes are used for casting.}
}
\value{
A \code{triptych_mcbdsc} object, that is a \code{vctrs_vctr} subclass, and has
a length equal to number of forecasting methods supplied in \code{x}. Each entry
is named according to the corresponding forecasting method,
and contains a list of named objects:
\itemize{
\item \code{estimate}: A data frame of the score decomposition.
\item \code{region}: An empty list. Adding confidence regions is not yet supported.
\item \code{x}: The numeric vector of original forecasts.
}
Access is most convenient through \code{\link[=estimates]{estimates()}}, \code{\link[=regions]{regions()}}, and \code{\link[=forecasts]{forecasts()}}.
}
\description{
A score decomposition splits the mean score into the three components of
miscalibration (MCB), discrimination (DSC), and uncertainty (UNC). Plotting
the DSC component against the MCB component allows for a quick visual
inspection of predictive performance for many forecasting methods.
}
\examples{
data(ex_binary, package = "triptych")

md <- mcbdsc(ex_binary)
md

autoplot(md)
estimates(md)

}
\seealso{
Accessors: \code{\link[=estimates]{estimates()}}, \code{\link[=regions]{regions()}}, \code{\link[=forecasts]{forecasts()}}, \code{\link[=observations]{observations()}}

Visualization: \code{\link[=plot.triptych_mcbdsc]{plot.triptych_mcbdsc()}}, \code{\link[=autoplot.triptych_mcbdsc]{autoplot.triptych_mcbdsc()}}
}
