% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time.R
\name{get_date_service_table}
\alias{get_date_service_table}
\title{Returns all possible date/service_id combinations as a data frame}
\usage{
get_date_service_table(gtfs_obj)
}
\arguments{
\item{gtfs_obj}{a gtfs_object as read by read_gtfs}
}
\value{
a date_service data frame
}
\description{
Use it to summarise service. For example, get a count of the number of services for a date. See example.
}
\examples{
library(dplyr)
local_gtfs_path <- system.file("extdata", "google_transit_nyc_subway.zip", package = "trread")
nyc <- read_gtfs(local_gtfs_path, local=TRUE)
nyc_services_by_date <- nyc \%>\% get_date_service_table()
# count the number of services running on each date
nyc_services_by_date \%>\% group_by(date) \%>\% count()

}
