% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivarts.r
\name{Grangercaus}
\alias{Grangercaus}
\title{\code{Grangercaus}  determines three values of BIC from a twodimensional VAR process}
\usage{
Grangercaus(x, y, p)
}
\arguments{
\item{x}{first time series}

\item{y}{second time series}

\item{p}{maximal order of VAR process}
}
\value{
out  list with components
 \item{BIC}{vector of length 3: }
  \tabular{ll}{
   BIC1 \tab minimum aic value for all possible lag structures \cr
   BIC2 \tab minimum aic value when Y is not included as regressor in the equation for X \cr
   BIC3 \tab minimum aic value when X is not included as regressor in the equation for Y  }
 \item{out1}{output of function lm for regression equation for x-series }
 \item{out2}{output of function lm for regression equation for y-series  }
}
\description{
\code{Grangercaus}  determines three values of BIC from a twodimensional VAR process
}
\examples{
\donttest{
data(ICECREAM)
out <- Grangercaus(ICECREAM[,1],ICECREAM[,2],3) 
}
}
