% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arbitration-methods.r
\docType{methods}
\name{update_ade}
\alias{update_ade}
\alias{update_ade,ADE-method}
\title{Updating an ADE model}
\usage{
update_ade(object, newdata, num_cores = 1)

\S4method{update_ade}{ADE}(object, newdata, num_cores = 1)
}
\arguments{
\item{object}{a \code{\link{ADE-class}} object.}

\item{newdata}{data used to update the ADE model. This should be
the data used to initially train the models (training set), together
with new observations (for example, validation set). Each model
is retrained using \code{newdata}.}

\item{num_cores}{A numeric value to specify the number of cores used to
train base and meta models. num_cores = 1
leads to sequential training of models. num_cores > 1
splits the training of the base models across num_cores cores.}
}
\description{
\strong{update_ade} is a generic function that combines
\code{\link{update_base_models}}, \code{\link{update_ade_meta}},
and \code{\link{update_weights}}.
}
\examples{
specs <- model_specs(
 learner = c("bm_svr", "bm_glm", "bm_mars"),
 learner_pars = NULL
)

data("water_consumption")
dataset <- embed_timeseries(water_consumption, 5)
# toy size for checks
train <- dataset[1:300, ]
validation <- dataset[301:400, ]
test <- dataset[401:500, ]

model <- ADE(target ~., train, specs)

preds_val <- predict(model, validation)
model <- update_ade(model, rbind.data.frame(train, validation))

preds_test <- predict(model, test)


}
\seealso{
\code{\link{ADE-class}} for building an ADE model;
\code{\link{update_weights}} for updating the weights of the ensemble (without
retraining the models); \code{\link{update_base_models}} for updating the
base models of an ensemble; and \code{\link{update_ade_meta}} for
updating the meta-models of an ADE model.

Other updating models: \code{\link{update_ade_meta}},
  \code{\link{update_weights}}
}
\concept{updating models}
