% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TARMA.test.R
\name{TARMA.test}
\alias{TARMA.test}
\title{ARMA versus TARMA supLM test for nonlinearity}
\usage{
TARMA.test(
  x,
  pa = 0.25,
  pb = 0.75,
  ar.ord,
  ma.ord,
  ma.fixed = TRUE,
  d,
  thd.range,
  method = "CSS-ML",
  ...
)
}
\arguments{
\item{x}{A univariate time series.}

\item{pa}{Real number in \code{[0,1]}. Sets the lower limit for the threshold search to the \code{100*pa}-th sample percentile.
The default is \code{0.25}}

\item{pb}{Real number in \code{[0,1]}. Sets the upper limit for the threshold search to the \code{100*pb}-th sample percentile.
The default is \code{0.75}}

\item{ar.ord}{Order of the AR part.}

\item{ma.ord}{Order of the MA part.}

\item{ma.fixed}{Logical. Only applies to testing ARMA vs TARMA. If \code{TRUE} computes the test where only the AR parameters are tested, see \insertCite{Gor21}{tseriesTARMA} for details.}

\item{d}{Delay parameter. Defaults to \code{1}.}

\item{thd.range}{Vector of optional user defined threshold range. If missing then \code{pa} and \code{pb} are used.}

\item{method}{Fitting method to be passed to \code{arima}.}

\item{\dots}{Additional arguments to be passed to \code{arima}.}
}
\value{
An object of class \code{TARMAtest} with components:
\describe{
\item{\code{statistic}}{The value of the supLM statistic.}
\item{\code{parameter}}{A named vector: \code{threshold} is the value that maximises the Lagrange Multiplier values.}
\item{\code{test.v}}{Vector of values of the LM statistic for each threshold given in \code{thd.range}.}
\item{\code{thd.range}}{Range of values of the threshold.}
\item{\code{fit.ARMA}}{The null model: ARMA fit over \code{x}.}
\item{\code{sigma2}}{Estimated innovation variance from the ARMA fit.}
\item{\code{data.name}}{A character string giving the name of the data.}
\item{\code{prop}}{Proportion of values of the series that fall in the lower regime.}
\item{\code{p.value}}{The p-value of the test. It is \code{NULL} for the asymptotic test.}
\item{\code{method}}{A character string indicating the type of test performed.}
\item{\code{d}}{The delay parameter.}
\item{\code{pa}}{Lower threshold quantile.}
\item{\code{dfree}}{Effective degrees of freedom. It is the number of tested parameters.}
}
}
\description{
Implements a supremum Lagrange Multiplier test for a ARMA specification versus
a TARMA specification. Includes the AR versus TAR test.
}
\details{
Implements an asymptotic supremum Lagrange Multiplier test to test an ARMA specification versus a TARMA specification.
If \code{ma.fixed=TRUE} (the default), the AR parameters are tested whereas the MA parameters are fixed. If \code{ma.fixed=FALSE} both the AR and the MA parameters are tested.
This is an asymptotic test and the value of the test statistic has to be compared with the critical values tabulated in \insertCite{Gor21}{tseriesTARMA} and \insertCite{And03}{tseriesTARMA}.
If \code{ma.ord=0} then the AR versus TAR test is used. Note that when \code{method='CSS'}, this is equivalent to \code{TAR.test}, which uses least squares.
}
\examples{
## a TARMA(1,1,1,1) where the threshold effect is on the AR parameters
set.seed(123)
x1    <- TARMA.sim(n=100, phi1=c(0.5,-0.5), phi2=c(0.0,0.8), theta1=0.5, theta2=0.5, d=1, thd=0.2)
TARMA.test(x1, ar.ord=1, ma.ord=1, d=1)
TARMA.test(x1, ar.ord=1, ma.ord=1, d=1, ma.fixed=FALSE) # full TARMA test

## a TARMA(1,1,1,1) where the threshold effect is on the MA parameters
set.seed(212)
x2    <- TARMA.sim(n=100, phi1=c(0.5,0.2), phi2=c(0.5,0.2), theta1=0.6, theta2=-0.6, d=1, thd=0.2)
TARMA.test(x2, ar.ord=1, ma.ord=1, d=1)
TARMA.test(x2, ar.ord=1, ma.ord=1, d=1, ma.fixed=FALSE) # full TARMA test

## a ARMA(1,1)
x3   <- arima.sim(n=100, model=list(order = c(1,0,1),ar=0.5, ma=0.5))
TARMA.test(x3, ar.ord=1, ma.ord=1, d=1)

## a TAR(1,1)
x4   <- TARMA.sim(n=100, phi1=c(0.5,-0.5), phi2=c(0.0,0.8), theta1=0, theta2=0, d=1, thd=0.2)
TARMA.test(x4, ar.ord=1, ma.ord=0, d=1)

## a AR(1)
x5   <- arima.sim(n=100, model=list(order = c(1,0,0),ar=0.5))
TARMA.test(x5, ar.ord=1, ma.ord=0, d=1)


}
\references{
\itemize{
\item \insertRef{Gor23}{tseriesTARMA}
\item \insertRef{And03}{tseriesTARMA}
}
}
\seealso{
\code{\link{TAR.test.B}} for the bootstrap version of the test. \code{\link{TARMAGARCH.test}}
for the robust version of the test with respect to GARCH innovations. \code{\link{TARMA.sim}} to simulate from a TARMA process.
}
\author{
Simone Giannerini, \email{simone.giannerini@unibo.it}

Greta Goracci, \email{greta.goracci@unibz.it}
}
