% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compengine.R
\name{firstzero_ac}
\alias{firstzero_ac}
\title{The first zero crossing of the autocorrelation function from software package \code{hctsa}}
\usage{
firstzero_ac(y, acfv = stats::acf(y, N - 1, plot = FALSE, na.action = na.pass))
}
\arguments{
\item{y}{the input time series}

\item{acfv}{vector of autocorrelation, if exist, used to avoid repeated computation.}
}
\value{
The first zero crossing of the autocorrelation function
}
\description{
Search up to a maximum of the length of the time series
}
\references{
B.D. Fulcher and N.S. Jones. hctsa: A computational framework for automated time-series phenotyping using massive feature extraction. Cell Systems 5, 527 (2017).

B.D. Fulcher, M.A. Little, N.S. Jones Highly comparative time-series analysis: the empirical structure of time series and their methods. J. Roy. Soc. Interface 10, 83 (2013).
}
\author{
Yangzhuoran Yang
}
