% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{autoplot.knnForecast}
\alias{autoplot.knnForecast}
\title{Create a ggplot object from a knnForecast object}
\usage{
\method{autoplot}{knnForecast}(forecast, highlight = "none", faceting = TRUE)
}
\arguments{
\item{forecast}{The knnForecast object.}

\item{highlight}{A string value indicating what elements should be
highlighted. Possible values are "none", "points" and
"neighbors".}

\item{faceting}{Logical. This applies only if the \code{highlight}
parameter is set to "neighbors". It indicates whether the different
nearest neighbors should be seen in different plots (\code{TRUE}) or in
one plot.}
}
\value{
The ggplot object representing a plotting with the forecast.
}
\description{
It uses a knnForecast object to create a ggplot object that plots a time
series and its forecast using KNN regression.
}
\examples{
pred <- knn_forecasting(USAccDeaths, h = 12, lags = 1:12, k = 2)
library(ggplot2)
autoplot(pred)
autoplot(pred, highlight = "neighbors")
}
