% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{nikkei}
\alias{nikkei}
\title{Japanese NIKKEI Stock Index}
\format{
\subsection{\code{nikkei}}{

A data.frame containing 4246 observations in 2 columns:
\describe{
\item{index}{The string date in YYYY-MM-DD format.}
\item{value}{The daily log returns}
}
}
}
\source{
Journal of Applied Econometrics Data Archive 2003-v18.6/giot-laurent from
the paper \dQuote{Value-at-Risk for Long and Short Trading Positions} by Giot, Pierre
and Sebastien Laurent, 2003, \emph{Journal of Applied Econometrics}, 18(6), pp. 641--664.
}
\usage{
nikkei
}
\description{
The daily log returns in percent of the NIKKEI stock index spanning the
period 1984-01-04 to 2000-12-22. In the original dataset there was a
duplicate date on 2000-08-31 (but with a different value). Therefore,
in order to correct this we have moved up the duplicate 2000-08-31 to
become 2000-09-01, and the 2000-09-01 to 2000-09-02. Since the next date
after this was 2000-09-04, no further adjustments were made. These changes
preserve the original data in the order they appeared, with a minimal
adjustment only to the index which has no impact on estimation, but avoiding
internal warnings which arise on checks to the index.
This dataset is included as it is used for the APARCH benchmark.
}
\keyword{datasets}
