% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse-key.R
\name{key_update}
\alias{key_update}
\title{Change/update key variables for a given \code{tbl_ts}}
\usage{
key_update(.data, ..., validate = TRUE)
}
\arguments{
\item{.data}{A \code{tbl_ts}.}

\item{...}{Expressions used to construct the key:
\itemize{
\item unspecified: drop every single variable from the old key.
\item \code{|} and \code{,} for nesting and crossing factors.
}}

\item{validate}{\code{TRUE} suggests to verify that each key or each combination
of key variables lead to unique time indices (i.e. a valid tsibble). It will
also make sure that the nested variables are arranged from lower level to
higher, if nested variables are passed to \code{key}. If you are sure that it's a
valid input, specify \code{FALSE} to skip the checks.}
}
\description{
Change/update key variables for a given \code{tbl_ts}
}
\examples{
# tourism could be identified by Region and Purpose ----
tourism \%>\% 
  key_update(Region, Purpose)
}
