% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretch.R
\name{stretch2}
\alias{stretch2}
\alias{stretch2_dfr}
\alias{stretch2_dfc}
\alias{pstretch}
\alias{pstretch_dfr}
\alias{pstretch_dfc}
\title{Stretching window calculation over multiple simultaneously}
\usage{
stretch2(.x, .y, .f, ..., .size = 1, .init = 1, .bind = FALSE)

stretch2_dfr(.x, .y, .f, ..., .size = 1, .init = 1, .bind = FALSE,
  .id = NULL)

stretch2_dfc(.x, .y, .f, ..., .size = 1, .init = 1, .bind = FALSE)

pstretch(.l, .f, ..., .size = 1, .init = 1, .bind = FALSE)

pstretch_dfr(.l, .f, ..., .size = 1, .init = 1, .bind = FALSE,
  .id = NULL)

pstretch_dfc(.l, .f, ..., .size = 1, .init = 1, .bind = FALSE)
}
\arguments{
\item{.x}{Objects to slide over simultaneously.}

\item{.y}{Objects to slide over simultaneously.}

\item{.f}{A function, formula, or atomic vector.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it
is converted to an extractor function. Character vectors index by name
and numeric vectors index by position; use a list to index by position
and name at different levels. Within a list, wrap strings in \code{\link[=get-attr]{get-attr()}}
to extract named attributes. If a component is not present, the value of
\code{.default} will be returned.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.size, .init}{An integer for moving and initial window size.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{.id}{If not \code{NULL} a variable with this name will be created
giving either the name or the index of the data frame.}

\item{.l}{A list of lists. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. List
names will be used if present.}
}
\description{
Fixing an initial window and expanding more observations:
\itemize{
\item \code{stretch2()} and \code{pstretch()} always returns a list.
\item \code{stretch2_lgl()}, \code{stretch2_int()}, \code{stretch2_dbl()}, \code{stretch2_chr()} use the same
arguments as \code{stretch2()}, but return vectors of the corresponding type.
\item \code{stretch2_dfr()} \code{stretch2_dfc()} return data frames using row-binding & column-binding.
}
}
\examples{
x <- 1:5
y <- 6:10
z <- 11:15
lst <- list(x = x, y = y, z = z)
df <- as.data.frame(lst)
stretch2(x, y, sum, .size = 2)
stretch2(lst, lst, ~ ., .size = 2)
stretch2(df, df, ~ ., .size = 2)
pstretch(lst, sum, .size = 1)
pstretch(list(lst, lst), ~ ., .size = 2)

###
# row-wise stretching over data frame
###

x <- as.Date("2017-01-01") + 0:364
df <- data.frame(x = x, y = seq_along(x))

tibble::tibble(
  data = pstretch(df, function(...) as_tibble(list(...)), .init = 10)
)
}
\seealso{
\itemize{
\item \link{stretch}
\item \link{slide2} for sliding window with overlapping observations
\item \link{tile2} for tiling window without overlapping observations
}
}
\alias{stretch2_lgl}
\alias{stretch2_chr}
\alias{stretch2_dbl}
\alias{stretch2_int}
\alias{pstretch_lgl}
\alias{pstretch_chr}
\alias{pstretch_dbl}
\alias{pstretch_int}
