% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsibble2ts.R
\name{guess_frequency}
\alias{guess_frequency}
\title{Guess a time frequency from other index objects}
\usage{
guess_frequency(x)
}
\arguments{
\item{x}{An index object including "yearmonth", "yearquarter", "Date" and others.}
}
\description{
\lifecycle{stable}

A possible frequency passed to the \code{ts()} function
}
\details{
If a series of observations are collected more frequently than
weekly, it is more likely to have multiple seasonalities. This function
returns a frequency value at its smallest. For example, hourly data would
have daily, weekly and annual frequencies of 24, 168 and 8766 respectively,
and hence it gives 24.
}
\examples{
guess_frequency(yearquarter(seq(2016, 2018, by = 1 / 4)))
guess_frequency(yearmonth(seq(2016, 2018, by = 1 / 12)))
guess_frequency(seq(as.Date("2017-01-01"), as.Date("2017-01-31"), by = 1))
guess_frequency(seq(
  as.POSIXct("2017-01-01 00:00"), as.POSIXct("2017-01-10 23:00"),
  by = "1 hour"
))
}
\references{
\url{https://robjhyndman.com/hyndsight/seasonal-periods/}
}
