% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-slide.R
\name{slide2}
\alias{slide2}
\alias{slide2_dfr}
\alias{slide2_dfc}
\alias{pslide}
\alias{pslide_dfr}
\alias{pslide_dfc}
\title{Sliding window calculation over multiple inputs simultaneously}
\usage{
slide2(
  .x,
  .y,
  .f,
  ...,
  .size = 1,
  .step = 1,
  .fill = NA,
  .partial = FALSE,
  .align = "right",
  .bind = FALSE
)

slide2_dfr(
  .x,
  .y,
  .f,
  ...,
  .size = 1,
  .step = 1,
  .fill = NA,
  .partial = FALSE,
  .align = "right",
  .bind = FALSE,
  .id = NULL
)

slide2_dfc(
  .x,
  .y,
  .f,
  ...,
  .size = 1,
  .step = 1,
  .fill = NA,
  .partial = FALSE,
  .align = "right",
  .bind = FALSE
)

pslide(
  .l,
  .f,
  ...,
  .size = 1,
  .step = 1,
  .fill = NA,
  .partial = FALSE,
  .align = "right",
  .bind = FALSE
)

pslide_dfr(
  .l,
  .f,
  ...,
  .size = 1,
  .step = 1,
  .fill = NA,
  .partial = FALSE,
  .align = "right",
  .bind = FALSE,
  .id = NULL
)

pslide_dfc(
  .l,
  .f,
  ...,
  .size = 1,
  .step = 1,
  .fill = NA,
  .partial = FALSE,
  .align = "right",
  .bind = FALSE
)
}
\arguments{
\item{.x, .y}{Objects to slide over simultaneously.}

\item{.f}{A function, formula, or vector (not necessarily atomic).

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.

If \strong{character vector}, \strong{numeric vector}, or \strong{list}, it is
converted to an extractor function. Character vectors index by
name and numeric vectors index by position; use a list to index
by position and name at different levels. If a component is not
present, the value of \code{.default} will be returned.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.size}{An integer for window size. If positive, moving forward from left
to right; if negative, moving backward (from right to left).}

\item{.step}{A positive integer for calculating at every specified step
instead of every single step.}

\item{.fill}{A value to fill at the left/center/right of the data range depending
on \code{.align} (\code{NA} by default).  \code{NULL} means no filling.}

\item{.partial}{if \code{TRUE}, partial sliding.}

\item{.align}{Align index at the "\strong{r}ight", "\strong{c}entre"/"center", or "\strong{l}eft"
of the window. If \code{.size} is even for center alignment, "centre-right" & "centre-left"
is needed.}

\item{.bind}{If \code{.x} is a list, should \code{.x} be combined before applying \code{.f}?
If \code{.x} is a list of data frames, row binding is carried out.}

\item{.id}{Either a string or \code{NULL}. If a string, the output will contain
a variable with that name, storing either the name (if \code{.x} is named) or
the index (if \code{.x} is unnamed) of the input. If \code{NULL}, the default, no
variable will be created.

Only applies to \verb{_dfr} variant.}

\item{.l}{A list of vectors, such as a data frame. The length of \code{.l}
determines the number of arguments that \code{.f} will be called with. List
names will be used if present.}
}
\description{
\lifecycle{defunct}

Please consider using the \href{https://davisvaughan.github.io/slider/}{slider} package.

Rolling window with overlapping observations:
\itemize{
\item \code{slide2()} and \code{pslide()} always returns a list.
\item \code{slide2_lgl()}, \code{slide2_int()}, \code{slide2_dbl()}, \code{slide2_chr()} use the same
arguments as \code{slide2()}, but return vectors of the corresponding type.
\item \code{slide2_dfr()} \code{slide2_dfc()} return data frames using row-binding & column-binding.
}
}
\seealso{
\itemize{
\item \link{tile2} for tiling window without overlapping observations
\item \link{stretch2} for expanding more observations
}

Other sliding window functions: 
\code{\link{slide}()}
}
\concept{sliding window functions}
\keyword{internal}
\alias{slide2_lgl}
\alias{slide2_chr}
\alias{slide2_int}
\alias{slide2_dbl}
\alias{pslide_lgl}
\alias{pslide_chr}
\alias{pslide_int}
\alias{pslide_dbl}
