% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaps.R
\name{scan_gaps}
\alias{scan_gaps}
\title{Scan a tsibble for implicit missing observations}
\usage{
scan_gaps(.data, .full = FALSE, .start = NULL, .end = NULL)
}
\arguments{
\item{.data}{A tsibble.}

\item{.full}{\itemize{
\item \code{FALSE} inserts \code{NA} for each keyed unit within its own period.
\item \code{TRUE} fills \code{NA} over the entire time span of the data (a.k.a. fully balanced panel).
\item \code{start()} pad \code{NA} to the same starting point (i.e. \verb{min(<index>)}) across units.
\item \code{end()} pad \code{NA} to the same ending point (i.e. \verb{max(<index>)}) across units.
}}

\item{.start, .end}{Set custom starting/ending time that allows to expand the
existing time spans.}
}
\description{
Scan a tsibble for implicit missing observations
}
\examples{
scan_gaps(pedestrian)
}
\seealso{
Other implicit gaps handling: 
\code{\link{count_gaps}()},
\code{\link{fill_gaps}()},
\code{\link{has_gaps}()}
}
\concept{implicit gaps handling}
