% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mass.R
\name{mass-deprecated}
\alias{mass-deprecated}
\title{Calculates the distance profile using MASS_V2 algorithm}
\usage{
mass(data_fft, query_window, data_size, window_size, data_mean, data_sd,
 query_mean, query_sd)
}
\arguments{
\item{data_fft}{precomputed data product.}

\item{query_window}{a \code{vector} of \code{numeric}. Query window.}

\item{data_size}{an \code{int}. The length of the reference data.}

\item{window_size}{an \code{int}. Sliding window size.}

\item{data_mean}{precomputed data moving average.}

\item{data_sd}{precomputed data moving standard deviation.}

\item{query_mean}{precomputed query average.}

\item{query_sd}{precomputed query standard deviation.}
}
\value{
Returns the \code{distance_profile} for the given query and the \code{last_product} for STOMP
algorithm.
}
\description{
Mueen's Algorithm for Similarity Search is The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance and Correlation Coefficient.
}
\references{
\itemize{
\item Abdullah Mueen, Yan Zhu, Michael Yeh, Kaveh Kamgar, Krishnamurthy Viswanathan,
Chetan Kumar Gupta and Eamonn Keogh (2015), The Fastest Similarity Search Algorithm for Time
Series Subsequences under Euclidean Distance
}

Website: \url{https://www.cs.unm.edu/~mueen/FastestSimilaritySearch.html}
}
\seealso{
\code{\link[=mass_pre]{mass_pre()}} to precomputation of input values.

\code{\link{tsmp-deprecated}}
}
\keyword{internal}
