% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmp.R
\name{pmp}
\alias{pmp}
\title{Pan-Matrix Profile}
\usage{
pmp(
  data,
  window_sizes = seq.int(from = 10, to = length(data)/2, length.out = 20),
  plot = FALSE,
  pmp_obj = NULL,
  n_workers = 1,
  verbose = getOption("tsmp.verbose", 2)
)
}
\arguments{
\item{data}{a \code{matrix} or a \code{vector} of \code{numeric}.}

\item{window_sizes}{a \code{vector} of the window sizes that will be evaluated. They will be rounded to the lower integer
and sorted. (Default is a sequence of 20 values from 10 to half data size).}

\item{plot}{a \code{logical}. If \code{TRUE}, every new computation will be plotted. (Default is \code{FALSE}).}

\item{pmp_obj}{a \code{PMP} object that may or not contain an upper bound value, and previous computed profiles. The function will
add new profiles, not replace. (Default is \code{NULL}).}

\item{n_workers}{an \code{int}. Number of workers for parallel. (Default is \code{1}).}

\item{verbose}{an \code{int}. See details. (Default is \code{2}).}
}
\value{
Returns a \code{PMP} object.
}
\description{
Computes the Pan-Matrix Profile (PMP) for the given time series.
}
\details{
The work closest in spirit to ours is VALMOD. The idea of VALMOD is to compute the MP for
the shortest length of interest, then use the information gleaned from it to guide a search
through longer subsequence lengths, exploiting lower bounds to prune off some calculations.
This idea works well for the first few of the longer subsequence lengths, but the lower bounds
progressively weaken, making the pruning ineffective. Thus, in the five case studies they
presented, the mean value of U/L was just 1.24. In contrast, consider that our termite example
in Fig. 15 has a U/L ratio of 240, more than two orders of magnitude larger. Thus, VALMOD is
perhaps best seen as finding motifs with some tolerance for a slightly (~25\%) too short
user-specified query length, rather than a true "motif-of-all-lengths" algorithm. Also note
that apart from the shortest length, VALMOD only gives some information for the other lengths,
unlike pmp, which contains exact distances for all subsequences of all lengths.

When just the \code{data} is provided, the exploration will be done using the default \code{window_sizes} that is a sequence
of 20 values between 10 and the half data size and the resulting object will have an \code{upper_bound} equals to \code{Inf}.
If an object is provided by the argument \code{pmp_obj}, this function will add more information to the resulting object,
never changing the values already computed.
\code{verbose} changes how much information is printed by this function; \code{0} means nothing, \code{1} means text, \code{2}
adds the progress bar, \code{3} adds the finish sound.

Talk about upper bound and window sizes
\enumerate{
\item upper_window will be set to Inf on new objects
1.1. upper_window will also be used for plot, and for discovery, it must not remove any existing data from the object
\item window_sizes is used for plot, it must not remove any mp inside the object
2.1. window_sizes tells the function what mp are stored, it may be updated with as.numeric(names(pmp))
\item the functions must be capable to handle the data without need to sort by window_size, but sort may be useful later(?)
}
}
\examples{
# Just compute
pan <- pmp(mp_gait_data)
\dontrun{
# Compute the upper bound, than add new profiles
pan <- pmp_upper_bound(mp_gait_data)
pan <- pmp(mp_gait_data, pmp_obj = pan)
}
}
