% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrG.R
\name{distr-g}
\alias{distr-g}
\alias{dg}
\alias{pg}
\alias{qg}
\alias{rg}
\alias{infg}
\alias{supg}
\title{The g distribution}
\usage{
dg(x, a = 0, b = 1, g = 0, log = FALSE, ...)

pg(q, a = 0, b = 1, g = 0, lower.tail = TRUE, log.p = FALSE, ...)

qg(p, a = 0, b = 1, g = 0, lower.tail = TRUE, log.p = FALSE)

rg(n, a = 0, b = 1, g = 0)

infg(a = 0, b = 1, g = 0)

supg(a = 0, b = 1, g = 0)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{a}{location parameter(s).}

\item{b}{scale parameter(s).}

\item{g}{skewness parameter(s).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{...}{arguments passed to \code{\link[rootSolve:uniroot.all]{rootSolve::uniroot.all()}}.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}
}
\value{
\code{dg} gives the density, \code{pg} gives the distribution function, \code{qg} gives the
quantile function, and \code{rg} generates random numbers.

The length of the result is determined by \code{n} for \code{rg}, and is the maximum
of the lengths of the numerical arguments for the other functions.

The numerical arguments other than \code{n} are recycled to the length of the
result. Only the first elements of the logical arguments are used.
}
\description{
Density (\code{dg}), distribution function (\code{pg}), quantile function (\code{qg}),
random generation (\code{rg}), and bounds of the support (\code{infg} and \code{supg}) of
the g distribution \insertCite{tukey1977}{tukeyGH}. All functions with the
exception of \code{rg} are vectorized with respect to all  arguments on the g
distribution (\code{x}, \code{q}, \code{p}, \code{a}, \code{b}, \code{g}). The functions are wrappers of
the g-and-h family with \code{h = 0}.
}
\references{
\insertAllCited{}
}
