% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tunable.R
\docType{data}
\name{tunable}
\alias{tunable}
\alias{no_param}
\alias{tunable.step}
\alias{tunable.model_spec}
\alias{tunable.step_embed}
\alias{tunable.step_umap}
\alias{tunable.step_woe}
\alias{tunable.step_texthash}
\alias{tunable.step_tf}
\alias{tunable.step_tokenfilter}
\alias{tunable.step_tokenize}
\alias{tunable.recipe}
\alias{tunable.workflow}
\alias{tunable.linear_reg}
\alias{tunable.logistic_reg}
\alias{tunable.multinomial_reg}
\alias{tunable.boost_tree}
\alias{tunable.nearest_neighbor}
\title{Find recommended methods for generating parameter values}
\format{An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 0 rows and 5 columns.}
\usage{
tunable(x, ...)

no_param

\method{tunable}{step}(x, ...)

\method{tunable}{model_spec}(x, ...)

\method{tunable}{step_embed}(x, ...)

\method{tunable}{step_umap}(x, ...)

\method{tunable}{step_woe}(x, ...)

\method{tunable}{step_texthash}(x, ...)

\method{tunable}{step_tf}(x, ...)

\method{tunable}{step_tokenfilter}(x, ...)

\method{tunable}{step_tokenize}(x, ...)

\method{tunable}{recipe}(x, ...)

\method{tunable}{workflow}(x, ...)

\method{tunable}{linear_reg}(x, ...)

\method{tunable}{logistic_reg}(x, ...)

\method{tunable}{multinomial_reg}(x, ...)

\method{tunable}{boost_tree}(x, ...)

\method{tunable}{nearest_neighbor}(x, ...)
}
\arguments{
\item{x}{An object, such as a recipe, recipe step, or \code{parsnip} model
specification.}

\item{...}{Not currently used.}
}
\value{
A tibble with a column for the parameter \code{name}, information on the
\emph{default} method for generating a corresponding parameter object, the
\code{source} of the parameter (e.g. "recipe", etc.), and the \code{component} within
the source. For the \code{component} column, a little more specificity is given
about the location of the parameter (e.g. "step_normalize" or recipes or
"boost_tree" for models). The \code{component_id} column contains the unique step
\code{id} field or, for models, a logical for whether the model specification
argument was a main parameter or one associated with the engine.
}
\description{
\code{\link[=tunable]{tunable()}} determines which parameters in an object \emph{can} be tuned along
with information about the parameters.
}
\details{
For a model specification, an engine must be chosen.

If the object has no tunable parameters, a tibble with no rows is returned.

The information about the default parameter object takes the form of a
named list with an element for the function call and an optional element for
the source of the function (e.g. the \code{dials} package). For model
specifications, If the parameter is unknown to the underlying \code{tunable}
method, a \code{NULL} is returned.
}
\examples{
\donttest{
library(recipes)

recipe(mpg ~ ., data = mtcars) \%>\%
  step_knnimpute(all_predictors()) \%>\%
  step_pca(all_predictors()) \%>\%
  tunable()

recipe(mpg ~ ., data = mtcars) \%>\%
  step_normalize(all_predictors()) \%>\%
  tunable()

library(parsnip)

boost_tree() \%>\%
  set_engine("xgboost") \%>\%
  tunable()

boost_tree() \%>\%
  set_engine("C5.0", rules = TRUE) \%>\%
  tunable()
}
}
\keyword{datasets}
\keyword{internal}
