% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/min_grid.R
\name{min_grid}
\alias{min_grid}
\alias{min_grid.model_spec}
\alias{min_grid.boost_tree}
\alias{min_grid.linear_reg}
\alias{min_grid.logistic_reg}
\alias{min_grid.mars}
\alias{min_grid.multinom_reg}
\alias{min_grid.nearest_neighbor}
\title{Determine the minimum set of model fits}
\usage{
min_grid(x, grid, ...)

\method{min_grid}{model_spec}(x, grid, ...)

\method{min_grid}{boost_tree}(x, grid, ...)

\method{min_grid}{linear_reg}(x, grid, ...)

\method{min_grid}{logistic_reg}(x, grid, ...)

\method{min_grid}{mars}(x, grid, ...)

\method{min_grid}{multinom_reg}(x, grid, ...)

\method{min_grid}{nearest_neighbor}(x, grid, ...)
}
\arguments{
\item{x}{A model specification.}

\item{grid}{A tibble with tuning parameter combinations.}

\item{...}{Not currently used.}
}
\value{
A tibble with the minimum tuning parameters to fit and an additional
list column with the parameter combinations used for prediction.
}
\description{
\code{min_grid} determines exactly what models should be fit in order to
evaluate the entire set of tuning parameter combinations. This is for
internal use only and the API may change in the near future.
}
\keyword{internal}
