% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/case_weights.R
\name{.use_case_weights_with_yardstick}
\alias{.use_case_weights_with_yardstick}
\alias{.use_case_weights_with_yardstick.hardhat_importance_weights}
\alias{.use_case_weights_with_yardstick.hardhat_frequency_weights}
\title{Determine if case weights should be passed on to yardstick}
\usage{
.use_case_weights_with_yardstick(x)

\method{.use_case_weights_with_yardstick}{hardhat_importance_weights}(x)

\method{.use_case_weights_with_yardstick}{hardhat_frequency_weights}(x)
}
\arguments{
\item{x}{A vector}
}
\value{
A single \code{TRUE} or \code{FALSE}.
}
\description{
This S3 method defines the logic for deciding when a case weight vector
should be passed to yardstick metric functions and used to measure model
performance. The current logic is that frequency weights (i.e.
\code{\link[hardhat:frequency_weights]{hardhat::frequency_weights()}}) are the only situation where this should
occur.
}
\examples{
library(parsnip)
library(dplyr)

frequency_weights(1:10) |>
  .use_case_weights_with_yardstick()

importance_weights(seq(1, 10, by = .1))|>
  .use_case_weights_with_yardstick()
}
