% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_positron_settings.R
\name{set_positron_settings}
\alias{set_positron_settings}
\title{Select Good Positron Settings}
\usage{
set_positron_settings(home_dir = path.expand("~"), set.binary = TRUE)
}
\arguments{
\item{home_dir}{Optional character string specifying the base directory to use
as the user's home directory. Defaults to \code{path.expand("~")}. Useful for
testing or custom setups.}

\item{set.binary}{Logical, defaults to \code{TRUE}. If \code{TRUE}, runs
\code{set_binary_only_in_r_profile()} after applying settings to configure binary
options in the R profile.}
}
\value{
Invisible \code{NULL}. The function’s purpose is its side effect: modifying
or creating the \code{settings.json} file. It also prints messages to the console
indicating actions taken.
}
\description{
Locates or creates the Positron \code{settings.json} file on Windows or macOS,
then ensures the \code{"rstudio.keymap.enable": true} setting is present to enable
RStudio keyboard shortcuts. If the setting already exists and is \code{true}, no
changes are made; otherwise, it is added or updated. \code{set.binary} argument
determines if \code{options(pkgType = 'binary')} should be added to the \code{.Rprofile}.
}
\details{
This function uses the \code{jsonlite} package to handle JSON operations and
creates the necessary directory structure if it doesn’t exist. It is
designed to work cross-platform by detecting the operating system and
constructing the appropriate file path to Positron’s user settings.
}
\examples{
\dontrun{
  # Run the function with default settings
  set_positron_settings()
  # Run with a custom home directory and disable binary setting
  set_positron_settings(home_dir = tempdir(), set.binary = FALSE)
}

}
