% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smoothest.R
\name{smoothest}
\alias{smoothest}
\title{Function to compute local polynomial estimation using rule of thumb for bandwidth selection}
\usage{
smoothest(t.seq, t.coeff, t.est, deltat)
}
\arguments{
\item{t.seq}{a vector of time points at each observation}

\item{t.coeff}{estimated coefficients}

\item{t.est}{time points at which to make the estimation}

\item{deltat}{a small constant which controls the time-lag of the effect of the 
mediator on the outcome, half the time between two time points}
}
\value{
\item{bw_alpha}{a number computed via Fan and Gijbels' (1996) rule of thumb for 
                        bandwidth selector for alpha coefficient.}

\item{bw_gamma}{a number computed via Fan and Gijbels' (1996) rule of thumb for 
                        bandwidth selector for gamma coefficient.}

\item{bw_beta}{a number computed via Fan and Gijbels' (1996) rule of thumb for 
                       bandwidth selector for beta coefficient.}

\item{bw_beta}{a number computed via Fan and Gijbels' (1996) rule of thumb for 
                       bandwidth selector for tau coefficient.}

\item{hat.alpha}{estimated treatment effect on mediator}

\item{hat.gamma}{estimated treatment effect on outcome, adjusted for mediator}

\item{hat.beta}{estimated mediator effect on outcome}

\item{hat.tau}{estimated treatment effect on outcome, not adjusting for mediator}

\item{est.M}{estimated mediation effect, product of hat.alpha and hat.beta}
}
\description{
Part of the set of internal functions called within the \code{tvma} function to assist 
in the estimation of the time varying mediation effect.
}
