% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R, R/two_samples.R
\name{cvm_test}
\alias{cvm_test}
\alias{cvm_stat}
\title{Cramer-von Mises Test}
\usage{
cvm_test(a, b, nboots = 2000, p = default.p, keep.boots = T, keep.samples = F)

cvm_stat(a, b, power = def_power)
}
\arguments{
\item{a}{a vector of numbers (or factors -- see details)}

\item{b}{a vector of numbers}

\item{nboots}{Number of bootstrap iterations}

\item{p}{power to raise test stat to}

\item{keep.boots}{Should the bootstrap values be saved in the output?}

\item{keep.samples}{Should the samples be saved in the output?}

\item{power}{power to raise test stat to}
}
\value{
Output is a length 2 Vector with test stat and p-value in that order. That vector has 3 attributes -- the sample sizes of each sample, and the number of bootstraps performed for the pvalue.
}
\description{
A two-sample test based on the Cramer-Von Mises test statistic (\code{cvm_stat}).
}
\details{
The CVM test compares two ECDFs by looking at the sum of the squared differences between them -- evaluated at each point in the joint sample. Formally -- if E is the ECDF of sample 1 and F is the ECDF of sample 2, then \deqn{CVM = \sum_{x\in k}|E(x)-F(x)|^p}{CVM = SUM_(x in k) |E(x)-F(x)|^p} where k is the joint sample. The test p-value is calculated by randomly resampling two samples of the same size using the combined sample. Intuitively the CVM test improves on KS by using the full joint sample, rather than just the maximum distance -- this gives it greater power against shifts in higher moments, like variance changes.

In the example plot below, the CVM statistic is the sum of the heights of the vertical black lines.

\figure{cvm.png}{Example CVM stat plot}

Inputs \code{a} and \code{b} can also be vectors of ordered (or unordered) factors, so long as both have the same levels and orderings. When possible, ordering factors will substantially increase power.
}
\section{Functions}{
\itemize{
\item \code{cvm_test}: Permutation based two sample Cramer-Von Mises test

\item \code{cvm_stat}: Permutation based two sample Cramer-Von Mises test
}}

\examples{
set.seed(314159)
vec1 = rnorm(20)
vec2 = rnorm(20,0.5)
out = cvm_test(vec1,vec2)
out
summary(out)
plot(out)

# Example using ordered factors
vec1 = factor(LETTERS[1:5],levels = LETTERS,ordered = TRUE)
vec2 = factor(LETTERS[c(1,2,2,2,4)],levels = LETTERS, ordered=TRUE)
cvm_test(vec1,vec2)
}
\seealso{
\code{\link[=dts_test]{dts_test()}} for a more powerful test statistic. See \code{\link[=ks_test]{ks_test()}} or \code{\link[=kuiper_test]{kuiper_test()}} for the predecessors to this test statistic. See \code{\link[=wass_test]{wass_test()}} and \code{\link[=ad_test]{ad_test()}} for the successors to this test statistic.
}
