% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mechanisms.R
\name{est_g}
\alias{est_g}
\title{Estimate the Generalized Propensity Score (Treatment Mechanism)}
\usage{
est_g(
  A,
  W,
  delta = 0,
  ipc_weights = rep(1, length(A)),
  fit_type = c("sl", "hal"),
  sl_learners_density = NULL,
  haldensify_args = list(n_bins = c(5, 10), grid_type = c("equal_range", "equal_mass"),
    lambda_seq = exp(seq(-1, -13, length = 300)), use_future = FALSE)
)
}
\arguments{
\item{A}{A \code{numeric} vector of observed treatment values.}

\item{W}{A \code{numeric} matrix of observed baseline covariate values.}

\item{delta}{A \code{numeric} value identifying a shift in the observed
value of the treatment under which observations are to be evaluated.}

\item{ipc_weights}{A \code{numeric} vector of observation-level weights, as
produced by the internal procedure to estimate the censoring mechanism
\code{estimate-ipc_weights}.}

\item{fit_type}{A \code{character} specifying whether to use Super Learner
(from \pkg{sl3}) or the Highly Adaptive Lasso (from \pkg{hal9001}) to
estimate the conditional treatment density.}

\item{sl_learners_density}{Object containing a set of instantiated learners
from \pkg{sl3}, to be used in fitting an ensemble model.}

\item{haldensify_args}{A \code{list} of argument to be directly passed to
\code{\link[haldensify]{haldensify}} when \code{fit_type} is set to
\code{"hal"}. Note that this invokes the Highly Adaptive Lasso instead of
Super Learner and is thus only feasible for relatively small data sets.}
}
\value{
A \code{data.table} with four columns, containing estimates of the
 generalized propensity score at a downshift (g(A - delta | W)), no shift
 (g(A | W)), an upshift (g(A + delta) | W), and an upshift of magitudie two
 (g(A + 2 delta) | W).
}
\description{
Estimate the Generalized Propensity Score (Treatment Mechanism)
}
\details{
Compute the propensity score (treatment mechanism) for the observed
 data, including the shift. This gives the propensity score for the observed
 data (at the observed A) and the shift (at A - delta).
}
