% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{preprocess}
\alias{preprocess}
\alias{preprocess,Tile,function-method}
\alias{preprocess,SpectralPack,function-method}
\title{Tile Preprocess}
\usage{
preprocess(data, FUN)

\S4method{preprocess}{Tile,`function`}(data, FUN)

\S4method{preprocess}{SpectralPack,`function`}(data, FUN)
}
\arguments{
\item{data}{An object of class \code{\link[=Tile-class]{Tile}} or \code{\link[=SpectralPack-class]{SpectralPack}}.}

\item{FUN}{A function to apply to the Spectra slot.}
}
\value{
The same object but with the Spectra slot updated by FUN. \code{\link[=SpectralPack-class]{SpectralPack}} objects return the wavelengths adjusted to the new extent, numbered from 1 to n (original values are lost).
}
\description{
The function is a wrapper that allows the user to perform a user-define function to each pixel spectrum. It can be called internally in \code{\link{mosaic_sam}} using the FUN argument when processing mosaics.

As exemplified below, the function allows you to interact with other R packages that provide common features to analyze spectral data. Beware that you will need to adjust the wavenumbers manually if you are resampling... unless that 'data' is an object of class \code{\link[=SpectralPack-class]{SpectralPack}}.
}
\examples{
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- preprocess(x, function(x){x+1})

\donttest{
# The function allows interacting with other R packages that provide common features
# for spectra analysis. For example, you can use the package "prospectr" to run
# a Savitzky-Golay filter.

library(prospectr)
# for Tile objects. NOTE that after the preprocess x@wavenumbers does not match dim(x@Spectra)[3]
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- preprocess(x, function(x){savitzkyGolay(x, 1, 3, 11, delta.wav = 2)})
dim(x@Spectra)[3] == length(x@wavenumbers) # BEWARE!

# for SpectralPack objects
x <- tile_read(base::system.file("extdata/tile.bsp", package = "uFTIR"))
x <- tile_base_corr(x)
x <- wavealign(x, primpke)
preprocess(x, function(x){savitzkyGolay(x, 1, 3, 11, delta.wav = 2)})

# Here the problem with the wavenumbers is gone
dim(x@Readings@Spectra)[3] == length(x@Readings@wavenumbers)
dim(x@Reference@Spectra)[3] == length(x@Reference@wavenumbers)
length(x@Readings@wavenumbers) == length(x@Reference@wavenumbers)
}
}
