% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSMARconstructor.R
\name{stmar_to_gstmar}
\alias{stmar_to_gstmar}
\title{Estimate a G-StMAR model based on a StMAR model with large degrees of freedom parameters}
\usage{
stmar_to_gstmar(gsmar, maxdf = 100, estimate, calc_std_errors,
  maxit = 100, custom_h = NULL)
}
\arguments{
\item{gsmar}{object of class \code{'gsmar'} created with the function \code{fitGSMAR} or \code{GSMAR}.}

\item{maxdf}{regimes with degrees of freedom parameter value larger than this will be turned into
GMAR type.}

\item{estimate}{set \code{TRUE} if the new model should be estimated with a variable metric algorithm
using the StMAR model parameter value as the initial value. By default \code{TRUE} iff the model
contains data.}

\item{calc_std_errors}{set \code{TRUE} if the approximate standard errors should be calculated.
By default \code{TRUE} iff the model contains data.}

\item{maxit}{the maximum number of iterations for the variable metric algorithm. Ignored if \code{estimate==FALSE}.}

\item{custom_h}{A numeric vector with same the length as the parameter vector: i:th element of custom_h is the difference
used in central difference approximation for partial differentials of the log-likelihood function for the i:th parameter.
If \code{NULL} (default), then the difference used for differentiating overly large degrees of freedom parameters
is adjusted to avoid numerical problems, and the difference is \code{6e-6} for the other parameters.}
}
\value{
Returns an object of class \code{'gsmar'} defining the specified GMAR, StMAR, or G-StMAR model. If data is supplied,
 the returned object contains (by default) empirical mixing weights, some conditional and unconditional moments, and quantile
 residuals. Note that the first p observations are taken as the initial values so the mixing weights, conditional moments, and
 quantile residuals start from the p+1:th observation (interpreted as t=1).
}
\description{
\code{stmar_to_gstmar} estimates a G-StMAR model based on a StMAR model with large degree
 of freedom parameters.
}
\details{
If a StMAR model contains large estimates for the degrees of freedom parameters,
  one should consider switching to the corresponding G-StMAR model that lets the corresponding
  regimes to be GMAR type. \code{stmar_to_gstmar} does this switch conveniently.
}
\examples{
\donttest{
 # These are long running examples and use parallel computing
 fit13tr <- fitGSMAR(logVIX, 1, 3, model="StMAR", restricted=TRUE,
  ncalls=2, seeds=1:2)
 fit13tr
 fit13gsr <- stmar_to_gstmar(fit13tr)
 fit13gsr
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2015. Gaussian Mixture Autoregressive model for univariate time series.
           \emph{Journal of Time Series Analysis}, \strong{36}, 247-266.
   \item Meitz M., Preve D., Saikkonen P. 2018. A mixture autoregressive model based on Student's t-distribution.
           arXiv:1805.04010 \strong{[econ.EM]}.
   \item There are currently no published references for the G-StMAR model, but it's a straightforward generalization with
         theoretical properties similar to the GMAR and StMAR models.
 }
}
\seealso{
\code{\link{fitGSMAR}}, \code{\link{GSMAR}}, \code{\link{iterate_more}}, \code{\link{get_gradient}},
 \code{\link{get_regime_means}}, \code{\link{swap_parametrization}}, \code{\link{stmar_to_gstmar}}
}
