% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb_bluedjinn.R
\name{poly_stat}
\alias{poly_stat}
\title{Calculate descriptive statistics of raster as segemented by polygons}
\usage{
poly_stat(x = NULL, spdf = NULL, count = 1, min = 1, max = 1,
  sum = 1, range = 1, mean = 1, var = 1, stddev = 1,
  quantile = 10, parallel = 1, giLinks = NULL)
}
\arguments{
\item{x}{list of spatial Raster* object(s)}

\item{spdf}{spatial point dataframe}

\item{count}{0 1 switch}

\item{min}{0 1 switch}

\item{max}{0 1 switch}

\item{sum}{0 1 switch}

\item{range}{0 1 switch}

\item{mean}{0 1 switch}

\item{var}{0 1 switch}

\item{stddev}{0 1 switch}

\item{quantile}{number of quantile}

\item{parallel}{run it parallel default is 1}

\item{giLinks}{list of GI tools cli pathes, default is NULL}
}
\description{
calculate statitiscs of polygon based raster extraction. Returns a spatialpolygon dataframe containing decriptive statistics
}
\examples{
\dontrun{
# required packages
require(uavRst)
require(link2GI)

# create and check the links to the GI software
giLinks<-uavRst::linkAll()
if (giLinks$saga$exist & giLinks$otb$exist & giLinks$grass$exist) {

# project folder
projRootDir<-tempdir()

# create subfolders please mind that the pathes are exported as global variables
paths<-link2GI::initProj(projRootDir = projRootDir, projFolders = c("run/"),
                         global = TRUE,
                         path_prefix = "path_")
# overide trailing backslash issue
 path_run<-ifelse(Sys.info()["sysname"]=="Windows", sub("/$", "",path_run),path_run)

# get the rgb image, chm and training data
url <- "https://github.com/gisma/gismaData/raw/master/uavRst/data/tutorial_data.zip"
utils::download.file(url, paste0(path_run,"tutorial_data.zip"))
unzip(zipfile = paste0(path_run,"tutorial_data.zip"), exdir = path_run)

# convert tif to SAGA
gdalUtils::gdal_translate(paste0(path_run,"rgb_3-3_train1.tif"),
                          paste0(path_run,"rgb_3-3_train1.sdat"),
                          overwrite = TRUE,
                          b = 1,
                          of = 'SAGA',
                          verbose = FALSE)

polyStat <- poly_stat("rgb_3-3_train1",
                      spdf = "rgb_3-3_train1.shp",
                      giLinks=giLinks)
                      
mapview::mapview(polyStat)
}
##+}

}
\author{
Chris Reudenbach
}
