% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{calculate_halflife}
\alias{calculate_halflife}
\title{Calculate the halflife of data}
\usage{
calculate_halflife(times = NULL, values = NULL, tmin = NULL,
  tmax = NULL)
}
\arguments{
\item{times}{- sequence of times}

\item{values}{- corresponding sequence of values}

\item{tmin}{- minimum time to include (\code{NULL})}

\item{tmax}{- maximum time to include  (\code{NULL})}
}
\value{
List with the following names
\itemize{
  \item{thalf} Halflife in units of times above
  \item{mod} Result of lm used to fit the log transformed data
  \item{df} Dataframe with the data and predicted values at the time within tmin and tmax
}
}
\description{
Determines the terminal halflife of a sequence of corresponding times and values with optional minimum and maximum times to censor data.
}
\examples{
x     = c(0:100)
y     = exp(-.1*x)
th    = calculate_halflife(times=x, values=y)
thalf = th$thalf 
}
