% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ubiquity.R
\name{system_od_general}
\alias{system_od_general}
\title{General Observation Details Function}
\usage{
system_od_general(pest, cfg, estimation = TRUE, details = FALSE)
}
\arguments{
\item{pest}{vector of parameters to be estimated}

\item{cfg}{ubiquity system object}

\item{estimation}{\code{TRUE} when called during an estimation and \code{FALSE} when called to test objective function or generate observation information for plotting}

\item{details}{\code{TRUE} to display information about cohorts as they are simulated (useful for debugging when passed through \code{\link{system_simulate_estimation_results}})}
}
\value{
If estimation is TRUE then the output is a matrix  of observation details of the format:
\preformatted{od$pred  = [TIME, OBS, PRED, VAR, OUTPUT, COHORT] }

  The values are the observed (\code{OBS}) data, predicted
  values (\code{PRED}) and variance (\code{VAR}) at the given \code{TIME}. The columns \code{OUTPUT} and
  \code{COHORT} can be used for sorting. These should be unique numbers.

 When estimation is \code{FALSE} we output \code{od$pred} is a data frame with the
 following headings:
\preformatted{od$pred  = [TIME, OBS, PRED, VAR, SMOOTH, OUTPUT, COHORT] }

  The \code{TIME}, \code{OBS}, \code{PRED} and \code{VAR} are the same as those listed above. The \code{SMOOTH}
  variable is \code{FALSE} for rows that correspond to records in the dataset and
  \code{TRUE} when the \code{PRED} represents the smooth predictions. The \code{OUTPUT} and \code{COHORT}
  columns here are text values used when defining the cohorts.
 
 
 Also the \code{od$all} list item is created with all of the simulation information
 stored for each cohort:
\preformatted{od$all = [ts.time, ts.ts1, ... ts.tsn, pred, name, cohort]}
\itemize{
  \item \code{tstime}             - timescale of the system
  \item \code{ts.ts1, ... ts.tsn} - timescales defined in the system
  \item \code{pred}               - smooth prediction
  \item \code{name}               - state or output name corresponding to the prediction
  \item \code{cohort}             - name of the cohort for these predictions
}

Lastly the field \code{isgood} will be set to \code{FALSE} if any problems are encountered, and \code{TRUE} if everything worked.
\preformatted{od$isgood = TRUE}
}
\description{
Used to calculate observation details based on 
cohorts created with \code{system_define_cohort}
}
\seealso{
\code{\link{system_define_cohort}} and \code{\link{system_simulate_estimation_results}}
}
