% Generated by roxygen2 (4.0.0): do not edit by hand
\name{rmd2pdf}
\alias{rmd2pdf}
\title{Render an R Markdown file into a PDF}
\usage{
rmd2pdf(file = "thesis.Rmd", template = "thesis_template.latex",
  biber = TRUE, saveTmpFiles = FALSE)
}
\arguments{
\item{file}{the location and name of the R Markdown file to be rendered.}

\item{template}{the location and name of the pandoc latex template to use
during the conversion from R Markdown to TeX.}

\item{biber}{logical flag indicating if biber (or biblatex) backend should
be run after xelatex is called.}

\item{saveTmpFiles}{logical flag indicating if intermediary files should be
kept after PDF file is created. If \code{FALSE} the files are deleted.}
}
\value{
The name of the xelatex rendered PDF.
}
\description{
Use knitr and pandoc to convert an R Markdown file into a
TeX file, and run xelatex (and biber) on the converted file to produce a PDF.
}
\details{
There's no markdown (yet) that allows for LaTeX preamble to be specified
inside a .md file. To get around this, we have to redefine a Pandoc latex
template using the preamble we'd normally use if we were using the LaTeX or
knitr templates. The template, \code{inst/rmarkdown/thesis_template.latex},
is a modification of the default template found via
\code{pandoc -D latex}. If you need to add more packages to your preamble,
e.g. \code{\\usepackage{amsmath}}, modify \code{thesis_template.latex}
accordingly.

Temporary files (e.g. .md's, .log's, .aux's, etc.) are stored in a temporary
(sub)directory, \code{tmp/}.
}
\examples{
\dontrun{
setwd("inst/rmarkdown")
rmd2pdf()
}
}

