% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_sigma.R
\name{var_bn}
\alias{var_bn}
\title{Variance of Bn}
\usage{
var_bn(group_sizes, md = NULL, data = NULL, numB = 2000)
}
\arguments{
\item{group_sizes}{A vector with two entries: size of group 1 and size of group 2.}

\item{md}{Matrix of distances between all data points.}

\item{data}{Data matrix. Each row represents an observation.}

\item{numB}{Number of resampling iterations. Only used if no groups are of size 1.}
}
\value{
Variance of Bn
}
\description{
Estimates the variance of the Bn statistic using the resampling
 procedure described in Cybis, Gabriela B., Marcio Valk, and Sílvia RC Lopes. "Clustering and classification problems in genetics through U-statistics."
Journal of Statistical Computation and Simulation 88.10 (2018)
and Valk, Marcio, and Gabriela Bettella Cybis. "U-statistical inference for hierarchical clustering." arXiv preprint arXiv:1805.12179 (2018).
}
\details{
Either \code{data} or \code{md} should be provided.
If data are entered directly, Bn will be computed considering the squared Euclidean
 distance, which is compatible with \code{\link{is_homo}}, \code{\link{uclust}} and
  \code{\link{uhclust}}.
}
\examples{

n=5
x=matrix(rnorm(n*20),ncol=20)
# option (a) entering the data matrix directly and considering a group of size 1
var_bn(c(1,4),data=x)

# option (b) entering the distance matrix and considering a groups of size 2 and 3
md=as.matrix(dist(x))^2
var_bn(c(2,3),md)



}
\seealso{
\code{\link{bn}}
}
