% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{txt_freq}
\alias{txt_freq}
\title{Frequency statistics of elements in a vector}
\usage{
txt_freq(x, exclude = c(NA, NaN), order = TRUE)
}
\arguments{
\item{x}{a vector}

\item{exclude}{logical indicating to exclude values from the table. Defaults to NA and NaN.}

\item{order}{logical indicating to order the resulting dataset in order of frequency. Defaults to TRUE.}
}
\value{
a data.frame with columns key, freq and freq_pct indicating the how 
many times each value in the vector \code{x} is occurring
}
\description{
Frequency statistics of elements in a vector
}
\examples{
x <- sample(LETTERS, 1000, replace = TRUE)
txt_freq(x)
x <- factor(x, levels = LETTERS)
txt_freq(x, order = FALSE)
}
