% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlp_flow.R
\name{dtm_cor}
\alias{dtm_cor}
\title{Pearson Correlation for Sparse Matrices}
\usage{
dtm_cor(x)
}
\arguments{
\item{x}{A matrix, potentially a sparse matrix such as a "dgTMatrix" object 
which is returned by \code{\link{document_term_matrix}}}
}
\value{
a correlation matrix
}
\description{
Pearson Correlation for Sparse Matrices. 
More memory and time-efficient than \code{cor(as.matrix(x))}.
}
\examples{
x <- data.frame(
 doc_id = c(1, 1, 2, 3, 4), 
 term = c("A", "C", "Z", "X", "G"), 
 freq = c(1, 5, 7, 10, 0))
dtm <- document_term_matrix(x)
dtm_cor(dtm)
}
\seealso{
\code{\link{document_term_matrix}}
}
