% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractor_functions.R
\name{extract_biomarker_qc_flags}
\alias{extract_biomarker_qc_flags}
\title{Extract NMR biomarker QC flags from a data.frame of UK Biobank fields}
\usage{
extract_biomarker_qc_flags(x)
}
\arguments{
\item{x}{\code{data.frame} with column names "eid" followed by extracted
fields e.g. "23774-0.0", "23774-1.0", \dots, "23767-1.0".}
}
\value{
a \code{data.frame} or \code{data.table} with column names "eid",
       and "visit_index" followed by columns for each biomarker
       e.g. "bOHbutyrate", \dots, "Valine".
}
\description{
Given an input \code{data.frame} loaded from a dataset extracted by
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
extracts the \href{https://biobank.ndph.ox.ac.uk/showcase/label.cgi?id=221}{UK Biobank fields}
corresponding to the
\href{https://biobank.ndph.ox.ac.uk/showcase/showcase/docs/nmrm_app4.pdf}{quality control (QC) flags for the NMR metaolomics biomarkers}
giving them short variable names as listed in the \code{\link{nmr_info}} information data sheet
available in this package. QC Flags are separated by "; " in each column where
there are multiple QC Flags for a single measurement.
}
\details{
\href{https://biobank.ctsu.ox.ac.uk/crystal/exinfo.cgi?src=accessing_data_guide}{ukbconv}
have one row per UKB biobank participant whose project specific sample
identifier is given in the first column named "eid". Columns following this
have the format "<field_id>-<visit_index>.<repeat_index>", where here <field_id>
corresponds to a biomarker of interest, e.g. 23774 for the QC Flags for
3-Hydroxybutyrate, and <visit_index> corresponds to the assessment time point,
e.g. 0 for baseline assessment, 1 for first repeat visit.

The <repeat_index> field is currently used by UK Biobank to index cases where
there are multiple QC Flags for a biomarker for a single participant and
visit_index. QC Flags are separated by "; " in each column where
there are multiple QC Flags for a single measurement.

In the returned \code{data.frame} there is single column for each biomarker,
with an additional column for the visit index. Rows are uniquely identifiable
by the combination of entries in columns "eid" and "visit_index".

If your UK Biobank project only has access to a subset of biomarkers, then
this function will only return the subset of ratios that can be computed from
the biomarker data provided.
}
\examples{
ukb_data <- ukbnmr::test_data # Toy example dataset for testing package
biomarker_qc_flags <- extract_biomarker_qc_flags(ukb_data)

}
