% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/street-crime.R
\name{ukc_street_crime}
\alias{ukc_street_crime}
\title{Street level crime}
\usage{
ukc_street_crime(lat, lng, date = NULL, crime_category = NULL)
}
\arguments{
\item{lat}{Latitude. Accepts a single value or a vector of values to create
a custom polygon.}

\item{lng}{Longitude. Accepts a single value or a vector of values to create
a custom polygon.}

\item{date}{The year and month in "YYYY-MM" form. If \code{NULL}, latest
available month will be returned.}

\item{crime_category}{The category of crime to return. Defaults to
returning all crimes. See \code{\link[=ukc_crime_category]{ukc_crime_category()}} for details.}
}
\value{
A tibble with details of street crimes.
}
\description{
Street level crime
}
\details{
\code{lat} and \code{lng} must be the same length.
}
\examples{
\donttest{
crime <- ukc_street_crime(
  lat = 51.5, lng = -0.6,
  crime_category = "bicycle-theft"
)

crime_poly <- ukc_street_crime(
  lat = c(52.268, 52.794, 52.130),
  lng = c(0.543, 0.238, 0.478)
)
}

}
