% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn.R
\name{umap.knn}
\alias{umap.knn}
\title{construct a umap.knn object describing nearest neighbors}
\usage{
umap.knn(indexes, distances)
}
\arguments{
\item{indexes}{matrix, integers linking data points to nearest neighbors}

\item{distances}{matrix, distance values between pairs of points specified
in the matrix of indexes}
}
\value{
object of class umap.knn, which is a list with matrices with indexes
of nearest neighbors and distances to those neighbors
}
\description{
construct a umap.knn object describing nearest neighbors
}
\examples{

# this example describes a set of three data points (indexes 1,2,3)
# which are equidistant from each other. Hence the distance between
# pairs (i, j) is 0 for i=j and 1 otherwise.
three.indexes = matrix(c(1,2,3,
                         2,1,3,
                         3,1,2), nrow=3, ncol=3)
three.distances = matrix(c(0, 1, 1,
                           0, 1, 1,
                           0, 1, 1), nrow=3, ncol=3)

umap.knn(three.indexes, three.distances)

}
