% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fit_and_reporting.r
\name{umxCompare}
\alias{umxCompare}
\title{umxCompare}
\usage{
umxCompare(base = NULL, comparison = NULL, all = TRUE, digits = 3,
  report = 1, file = "tmp.html")
}
\arguments{
\item{base}{The base \code{\link{mxModel}} for comparison}

\item{comparison}{The model (or list of models) which will be compared for fit with the base model (can be empty)}

\item{all}{Whether to make all possible comparisons if there is more than one base model (defaults to T)}

\item{digits}{rounding for p etc.}

\item{report}{Optionally add sentences for inclusion inline in a paper (report= 2)
and output to an html table which will open your default browser (report = 3).
(This is handy for getting tables into Word, markdown, and other text systems!)}

\item{file}{file to write html too if report=3 (defaults to "tmp.html")}
}
\description{
umxCompare compares two or more \code{\link{mxModel}}s.
If you leave comparison blank, it will just give fit info for the base model
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- mxModel("One Factor", type = "RAM",
	manifestVars = manifests, latentVars = latents,
	mxPath(from = latents, to = manifests),
	mxPath(from = manifests, arrows = 2),
	mxPath(from = latents, arrows = 2, free = FALSE, values = 1.0),
	mxData(cov(demoOneFactor), type = "cov", numObs = 500)
)
m1 = umxRun(m1, setLabels = TRUE, setValues = TRUE)
m2 = umxReRun(m1, update = "G_to_x2", name = "drop_path_2_x2")
umxCompare(m1, m2)
mxCompare(m1, m2) # what OpenMx gives by default
umxCompare(m1, m2, report = 2) # Add English-sentence descriptions
\dontrun{
umxCompare(m1, m2, report = 3) # Open table in browser
}
m3 = umxReRun(m2, update = "G_to_x3", name = "drop_path_2_x2_and_3")
umxCompare(m1, c(m2, m3))
umxCompare(c(m1, m2), c(m2, m3), all = TRUE)
}
\references{
- \url{http://www.github.com/tbates/umx/}
}
\seealso{
- \code{\link{mxCompare}}, \code{\link{umxSummary}}, \code{\link{umxRun}},

Other Reporting functions: \code{\link{RMSEA.MxModel}};
  \code{\link{RMSEA.summary.mxmodel}}; \code{\link{RMSEA}};
  \code{\link{coef.MxModel}};
  \code{\link{confint.MxModel}};
  \code{\link{extractAIC.MxModel}};
  \code{\link{logLik.MxModel}}; \code{\link{plot.MxModel}},
  \code{\link{umxPlot}}; \code{\link{plot}},
  \code{\link{plot.MxModel.ACE}}, \code{\link{umxPlotACE}};
  \code{\link{residuals.MxModel}};
  \code{\link{umxCI_boot}}; \code{\link{umxCI}};
  \code{\link{umxExpCov}}; \code{\link{umxExpMeans}};
  \code{\link{umxFitIndices}};
  \code{\link{umxStandardizeModel}};
  \code{\link{umxSummary.MxModel}};
  \code{\link{umx_drop_ok}}
}

