% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/build_run_modify.r
\name{umxSetParameters}
\alias{umxSetParameters}
\title{umxSetParameters}
\usage{
umxSetParameters(model, labels, free = NULL, values = NULL,
  newlabels = NULL, lbound = NULL, ubound = NULL, indep = FALSE,
  strict = TRUE, name = NULL)
}
\arguments{
\item{model}{an \code{\link{mxModel}} to WITH}

\item{labels}{= labels to find}

\item{free}{= new value for free}

\item{values}{= new values}

\item{newlabels}{= newlabels}

\item{lbound}{= value for lbound}

\item{ubound}{= value for ubound}

\item{indep}{= whether to look in indep models}

\item{strict}{whether to complain if labels not found}

\item{name}{= new name for the returned model}
}
\value{
- \code{\link{mxModel}}
}
\description{
umxSetParameters currently just a wrapper to omxSetParameters to ease user discovery.
this also underlies to update, allowing homology with \code{\link{update}}()
for lm models by freeing or fixing labeled parameters.
It also set starts for parameters which now have identical labels
}
\examples{
require(OpenMx)
data(demoOneFactor)
latents  = c("G")
manifests = names(demoOneFactor)
m1 <- umxRAM("One Factor", data = mxData(demoOneFactor, type = "raw"),
	umxPath(from = latents, to = manifests),
	umxPath(v.m. = manifests),
	umxPath(v1m0 = latents)
)
parameters(m1, free=TRUE)
m2 = umxSetParameters(m1, "G_to_x1", newlabels= "G_to_x2")
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
- \code{\link{umxLabel}}

Other Modify or Compare Models: \code{\link{parameters}},
  \code{\link{umxGetParameters}}; \code{\link{umxAdd1}};
  \code{\link{umxDrop1}}; \code{\link{umxEquate}};
  \code{\link{umxFixAll}}; \code{\link{umxMI}};
  \code{\link{umxUnexplainedCausalNexus}};
  \code{\link{umx}}, \code{\link{umx-package}}
}

