% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated_old_twin_versions.R
\name{umxPlotCPold}
\alias{umxPlotCPold}
\title{Draw and display a graphical figure of Common Pathway model}
\usage{
umxPlotCPold(x = NA, file = "name", digits = 2, means = FALSE,
  std = TRUE, format = c("current", "graphviz", "DiagrammeR"),
  SEstyle = FALSE, strip_zero = TRUE, ...)
}
\arguments{
\item{x}{The Common Pathway \code{\link{mxModel}} to display graphically}

\item{file}{The name of the dot file to write: NA = none; "name" = use the name of the model}

\item{digits}{How many decimals to include in path loadings (defaults to 2)}

\item{means}{Whether to show means paths (defaults to FALSE)}

\item{std}{Whether to standardize the model (defaults to TRUE)}

\item{format}{= c("current", "graphviz", "DiagrammeR")}

\item{SEstyle}{report "b (se)" instead of "b [lower, upper]" (Default)}

\item{strip_zero}{Whether to strip the leading "0" and decimal point from parameter estimates (default = TRUE)}

\item{...}{Optional additional parameters}
}
\value{
- Optionally return the dot code
}
\description{
Options include digits (rounding), showing means or not, and which output format is desired.
}
\examples{
\dontrun{
umxPlotCPold(yourCP_Model) # no need to remember a special name: plot works fine!
}
}
\references{
- \url{https://tbates.github.io}
}
\seealso{
- \code{\link{plot}()}, \code{\link{umxSummary}()} work for IP, CP, GxE, SAT, and ACE models.

- \code{\link{umxCP}}

Other Plotting functions: \code{\link{plot.MxLISRELModel}},
  \code{\link{plot.MxModel}}, \code{\link{umxPlotACEcov}},
  \code{\link{umxPlotACEv}}, \code{\link{umxPlotACE}},
  \code{\link{umxPlotCP}}, \code{\link{umxPlotGxEbiv}},
  \code{\link{umxPlotGxE}}, \code{\link{umxPlotIP}},
  \code{\link{umxPlotSexLim}},
  \code{\link{umxPlotSimplex}}, \code{\link{umx}}

Other Twin Reporting Functions: \code{\link{umxPlotCP}},
  \code{\link{umxReduceACE}}, \code{\link{umxReduceGxE}},
  \code{\link{umxReduce}},
  \code{\link{umxSummarizeTwinData}}, \code{\link{umx}}
}
\concept{Plotting functions}
\concept{Twin Reporting Functions}
