% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_read_lower}
\alias{umx_read_lower}
\title{Read lower-triangle of data matrix from console or file}
\usage{
umx_read_lower(file = "", diag = TRUE, names = NULL,
  ensurePD = FALSE)
}
\arguments{
\item{file}{Path to a file to read (Default "" will read from user input)}

\item{diag}{Whether the data include the diagonal. Defaults to TRUE}

\item{names}{The default names for the variables.
Defaults to as.character(paste("X", 1:n, sep=""))}

\item{ensurePD}{Whether to coerce the resultant matrix to positive definite (Defaults to FALSE)}
}
\value{
- \code{\link{matrix}}
}
\description{
umx_read_lower will read a lower triangle of data, either from the 
console, or from file, and return a full matrix, optionally coerced to
positive definite. This is useful, especially when copying data from a paper
that includes just the lower triangle of a correlation matrix.
}
\examples{
\dontrun{
require(umx) # for umxRAM
IQtests = c("brainstorm", "matrix", "moral", "shopping", "typing")
allCols = c("C", IQtests, "avgIQ", "maxIQ", "video")

df = umx_read_lower(file = "", diag = FALSE)
0.38
0.86	0.30
0.42	0.12	0.27
0.66	0.21	0.38	0.18
0.80	0.13	0.50	0.25	0.43
0.19	0.11	0.19	0.12	-0.06	0.22
0.27	0.09	0.33	0.05	-0.04	0.28	.73
0.52	0.17	0.38	0.37	0.39	0.44	0.18	0.13

dimnames(df) = list(allCols, allCols) # manually add

df = umx_read_lower(file = "", diag = FALSE, names = allCols, ensurePD= TRUE)
0.38
0.86	0.30
0.42	0.12	0.27
0.66	0.21	0.38	0.18
0.80	0.13	0.50	0.25	0.43
0.19	0.11	0.19	0.12	-0.06	0.22
0.27	0.09	0.33	0.05	-0.04	0.28	.73
0.52	0.17	0.38	0.37	0.39	0.44	0.18	0.13


round(df, 2) 

m1 = umxRAM("wooley", data = mxData(df, type="cov", numObs = 90),
	umxPath("g", to = IQtests),
	umxPath(var = "g", fixedAt= 1),
	umxPath(var = IQtests)
)
summary(m1)
}
}
\references{
- \url{https://github.com/tbates/umx}, \url{https://tbates.github.io}
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxDescribeDataWLS}},
  \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}}, \code{\link{umx_cov2raw}},
  \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_polychoric}},
  \code{\link{umx_polypairwise}},
  \code{\link{umx_polytriowise}}, \code{\link{umx_rename}},
  \code{\link{umx_reorder}}, \code{\link{umx_stack}},
  \code{\link{umx_swap_a_block}}, \code{\link{umx}}
}
\concept{Data Functions}
