% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_stack}
\alias{umx_stack}
\title{Stack data like stack() does, with more control.}
\usage{
umx_stack(x, select, passalong, valuesName = "values",
  groupName = "ind")
}
\arguments{
\item{x}{a dataframe containing twin data.}

\item{select}{The variables to stack (wide 2 long)}

\item{passalong}{Variables to preserve on each row (e.g. age)}

\item{valuesName}{The name for the new stacked column (default = "values")}

\item{groupName}{The name for the column containing the grouping variable (default = "ind")}
}
\value{
- long-format dataframe
}
\description{
Operates like \code{\link{stack}}, but can preserve ("passalong") other variables on each row,
and allows the user control over the values and group column names for ease of use.
}
\examples{

# Base-R stack function
df = stack(mtcars, select = c("disp", "hp"), drop=FALSE)

# umx_stack, with additional variables passed along 
df= umx_stack(mtcars, select= c("disp", "hp"), passalong= "mpg")
str(df) # ind is a factor, with levels select
ggplot2::qplot(x = mpg, y= values, color=ind, data = df)
df= umx_stack(mtcars, select= c("disp", "hp"), passalong= "mpg")
ggplot2::qplot(x = mpg, y= values, group="ind", data = df)
}
\seealso{
Other Data Functions: \code{\link{umxCovData}},
  \code{\link{umxDescribeDataWLS}},
  \code{\link{umxHetCor}},
  \code{\link{umxPadAndPruneForDefVars}},
  \code{\link{umx_as_numeric}}, \code{\link{umx_cov2raw}},
  \code{\link{umx_lower2full}},
  \code{\link{umx_make_MR_data}},
  \code{\link{umx_make_TwinData}},
  \code{\link{umx_make_bin_cont_pair_data}},
  \code{\link{umx_make_fake_data}},
  \code{\link{umx_polychoric}},
  \code{\link{umx_polypairwise}},
  \code{\link{umx_polytriowise}},
  \code{\link{umx_read_lower}}, \code{\link{umx_rename}},
  \code{\link{umx_reorder}},
  \code{\link{umx_swap_a_block}}, \code{\link{umx}}
}
\concept{Data Functions}
