% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_and_utility.R
\name{umx_standardize_RAM}
\alias{umx_standardize_RAM}
\title{Return a standardized version of a Structural Model}
\usage{
umx_standardize_RAM(model, ...)
}
\arguments{
\item{model}{The \code{\link{mxModel}} you wish to standardize}

\item{...}{Other options}
}
\description{
umx_standardize_RAM takes a RAM-style model, and returns standardized version.
}
\examples{
require(umx)
data(demoOneFactor)
latents  = c("g")
manifests = names(demoOneFactor)
m1 = umxRAM("One Factor", data = demoOneFactor, type = "cov",
	umxPath(latents, to = manifests),
	umxPath(var = manifests),
	umxPath(var = latents, fixedAt = 1.0)
)

m1 = umx_standardize_RAM(m1)
m1 = umx_standardize(m1)
umxSummary(m1)
}
\references{
- \url{https://github.com/tbates/umx}
}
\seealso{
Other Reporting functions: \code{\link{RMSEA.MxModel}},
  \code{\link{RMSEA.summary.mxmodel}}, \code{\link{RMSEA}},
  \code{\link{extractAIC.MxModel}}, \code{\link{loadings}},
  \code{\link{residuals.MxModel}},
  \code{\link{umxCI_boot}}, \code{\link{umxCI}},
  \code{\link{umxCompare}}, \code{\link{umxConfint}},
  \code{\link{umxExpCov}}, \code{\link{umxExpMeans}},
  \code{\link{umxFitIndices}}, \code{\link{umxPlotACEv}},
  \code{\link{umxSummary.MxModel}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}},
  \code{\link{umx_drop_ok}}
}
\concept{Reporting functions}
