% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/umxSexLim.R
\name{umxSexLim}
\alias{umxSexLim}
\title{Multivariate twin analysis with sex limitation}
\usage{
umxSexLim(name = "sexlim", selDVs, mzmData, dzmData, mzfData, dzfData,
  dzoData, sep = NA, A_or_C = c("A", "C"),
  autoRun = getOption("umx_auto_run"), optimizer = NULL)
}
\arguments{
\item{name}{The name of the model (Default = "sexlim")}

\item{selDVs}{BASE NAMES of the variables in the analysis. You MUST provide suffixes.}

\item{mzmData}{Dataframe containing the MZ male data}

\item{dzmData}{Dataframe containing the DZ male data}

\item{mzfData}{Dataframe containing the MZ female data}

\item{dzfData}{Dataframe containing the DZ female data}

\item{dzoData}{Dataframe containing the DZ opposite-sex data (be sure and get in right order)}

\item{sep}{Suffix used for twin variable naming. Allows using just the base names in selVars}

\item{A_or_C}{Whether to model sex-limitation on A or on C. (Defaults to "A")}

\item{autoRun}{Whether to run the model and return it, or just return it.}

\item{optimizer}{optionally set the optimizer. Default (NULL) does nothing.}
}
\value{
- \code{\link{mxModel}} of subclass mxModel.CFSexLim
}
\description{
Build a multivariate twin analysis with sex limitation based on a correlated factors model.
This allows Quantitative & Qualitative Sex-Limitation. The correlation approach ensures that variable order
does NOT affect ability of model to account for DZOS data.
Restrictions: Assumes means and variances can be equated across birth order within zygosity groups
}
\examples{
# =========================
# = Load and Process Data =
# =========================
require(umx)
data("us_skinfold_data")
# rescale vars
us_skinfold_data[, c('bic_T1', 'bic_T2')] <- us_skinfold_data[, c('bic_T1', 'bic_T2')]/3.4
us_skinfold_data[, c('tri_T1', 'tri_T2')] <- us_skinfold_data[, c('tri_T1', 'tri_T2')]/3
us_skinfold_data[, c('caf_T1', 'caf_T2')] <- us_skinfold_data[, c('caf_T1', 'caf_T2')]/3
us_skinfold_data[, c('ssc_T1', 'ssc_T2')] <- us_skinfold_data[, c('ssc_T1', 'ssc_T2')]/5
us_skinfold_data[, c('sil_T1', 'sil_T2')] <- us_skinfold_data[, c('sil_T1', 'sil_T2')]/5

# Variables for Analysis
selDVs = c('ssc','sil','caf','tri','bic') # (was Vars)
# Data objects for Multiple Groups
mzmData = subset(us_skinfold_data, zyg == 1)
mzfData = subset(us_skinfold_data, zyg == 2)
dzmData = subset(us_skinfold_data, zyg == 3)
dzfData = subset(us_skinfold_data, zyg == 4)
dzoData = subset(us_skinfold_data, zyg == 5)

m1 = umxSexLim(selDVs = selDVs, sep = "_T", A_or_C = "A", autoRun=FALSE,
	  mzmData = mzmData, dzmData = dzmData, 
       mzfData = mzfData, dzfData = dzfData, 
       dzoData = dzoData)
# m1 = mxRun(m1)
# umxSummary(m1)
# summary(m1)
# summary(m1)$Mi

}
\references{
- Neale et al. (2006). 
Multivariate genetic analysis of sex-lim and GxE interaction.
\emph{Twin Research & Human Genetics}, \bold{9}, pp. 481--489.
}
\seealso{
Other Twin Modeling Functions: \code{\link{umxACE_cov_fixed}},
  \code{\link{umxACEcov}}, \code{\link{umxACEv}},
  \code{\link{umxACE}}, \code{\link{umxCP}},
  \code{\link{umxGxE_biv}}, \code{\link{umxGxE_window}},
  \code{\link{umxGxE}}, \code{\link{umxIP}},
  \code{\link{umxSimplex}}, \code{\link{umxSummaryACEcov}},
  \code{\link{umxSummaryACEv}},
  \code{\link{umxSummaryACE}}, \code{\link{umxSummaryCP}},
  \code{\link{umxSummaryGxE_biv}},
  \code{\link{umxSummaryGxE}}, \code{\link{umxSummaryIP}},
  \code{\link{umxSummarySexLim}},
  \code{\link{umxSummarySimplex}}, \code{\link{umx}},
  \code{\link{xmu_twin_check}}
}
